/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAckTask
extends AbstractTask {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");

    public MessageAckTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        String seq = this.pkg.getHeader().getSeq();
        Command cmd = this.pkg.getHeader().getCommand();
        if (seq == null) {
            this.logger.error("MessageAckTask failed, seq cannot be null|user={}", (Object)this.session.getClient());
            return;
        }
        DownStreamMsgContext downStreamMsgContext = this.session.getPusher().getUnAckMsg().get(seq);
        if (downStreamMsgContext != null) {
            downStreamMsgContext.ackMsg();
            this.session.getPusher().getUnAckMsg().remove(seq);
        } else {
            this.logger.warn("MessageAckTask, seq:{}, downStreamMsgContext not in downStreamMap,client:{}", (Object)seq, (Object)this.session.getClient());
        }
        this.messageLogger.info("pkg|c2eventMesh|cmd={}|seq=[{}]|user={}|wait={}ms|cost={}ms", new Object[]{cmd, seq, this.session.getClient(), taskExecuteTime - this.startTime, System.currentTimeMillis() - this.startTime});
    }
}

