/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.Utils;

public class HeartBeatTask
extends AbstractTask {
    public HeartBeatTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        try {
            if (this.session != null) {
                this.session.notifyHeartbeat(this.startTime);
            }
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            this.logger.error("HeartBeatTask failed|user={}|errMsg={}", (Object)this.session.getClient(), (Object)e);
            res.setHeader(new Header(Command.HEARTBEAT_RESPONSE, OPStatus.FAIL.getCode().intValue(), "exception while heartbeating", this.pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(res, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
        }
    }
}

