/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send;

import io.openmessaging.api.Message;
import io.openmessaging.api.SendCallback;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.RRCallback;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.UpStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSender {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final Logger logger = LoggerFactory.getLogger(SessionSender.class);
    private Session session;
    public long createTime = System.currentTimeMillis();
    public AtomicLong upMsgs = new AtomicLong(0L);
    public AtomicLong failMsgCount = new AtomicLong(0L);
    private static final int TRY_PERMIT_TIME_OUT = 5;
    private Semaphore upstreamBuff;

    public String toString() {
        return "SessionSender{upstreamBuff=" + this.upstreamBuff.availablePermits() + ",upMsgs=" + this.upMsgs.longValue() + ",failMsgCount=" + this.failMsgCount.longValue() + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }

    public Semaphore getUpstreamBuff() {
        return this.upstreamBuff;
    }

    public SessionSender(Session session) {
        this.session = session;
        this.upstreamBuff = new Semaphore(session.getEventMeshTCPConfiguration().eventMeshTcpSessionUpstreamBufferSize);
    }

    public EventMeshTcpSendResult send(Header header, Message msg, SendCallback sendCallback, long startTime, long taskExecuteTime) {
        try {
            if (this.upstreamBuff.tryAcquire(5L, TimeUnit.MILLISECONDS)) {
                this.upMsgs.incrementAndGet();
                UpStreamMsgContext upStreamMsgContext = null;
                Command cmd = header.getCommand();
                if (Command.REQUEST_TO_SERVER == cmd) {
                    long ttl = msg.getSystemProperties("TTL") != null ? Long.parseLong(msg.getSystemProperties("TTL")) : 3000L;
                    upStreamMsgContext = new UpStreamMsgContext(header.getSeq(), this.session, msg);
                    ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).request(upStreamMsgContext, sendCallback, this.initSyncRRCallback(header, startTime, taskExecuteTime), ttl);
                } else if (Command.RESPONSE_TO_SERVER == cmd) {
                    String cluster = msg.getUserProperties("CLUSTER");
                    if (!StringUtils.isEmpty((CharSequence)cluster)) {
                        String replyTopic = "rr-reply-topic";
                        replyTopic = cluster + "-" + replyTopic;
                        msg.getSystemProperties().put("DESTINATION", replyTopic);
                    }
                    upStreamMsgContext = new UpStreamMsgContext(header.getSeq(), this.session, msg);
                    ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).reply(upStreamMsgContext);
                    this.upstreamBuff.release();
                } else {
                    upStreamMsgContext = new UpStreamMsgContext(header.getSeq(), this.session, msg);
                    ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).send(upStreamMsgContext, sendCallback);
                }
            } else {
                this.logger.warn("send too fast,session flow control,session:{}", (Object)this.session.getClient());
                return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.SEND_TOO_FAST, EventMeshTcpSendStatus.SEND_TOO_FAST.name());
            }
            ((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getEventMeshTcpMonitor().getEventMesh2mqMsgNum().incrementAndGet();
        }
        catch (Exception e) {
            this.logger.warn("SessionSender send failed", (Throwable)e);
            if (!(e instanceof InterruptedException)) {
                this.upstreamBuff.release();
            }
            this.failMsgCount.incrementAndGet();
            return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.OTHER_EXCEPTION, e.getCause().toString());
        }
        return new EventMeshTcpSendResult(header.getSeq(), EventMeshTcpSendStatus.SUCCESS, EventMeshTcpSendStatus.SUCCESS.name());
    }

    private RRCallback initSyncRRCallback(final Header header, final long startTime, final long taskExecuteTime) {
        return new RRCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Message msg) {
                String seq = header.getSeq();
                msg.getSystemProperties().put("rsp_mq2eventMesh_timestamp", String.valueOf(System.currentTimeMillis()));
                msg.getSystemProperties().put("rsp_receive_eventMesh_ip", ((SessionSender)SessionSender.this).session.getEventMeshTCPConfiguration().eventMeshServerIp);
                ((ClientGroupWrapper)SessionSender.this.session.getClientGroupWrapper().get()).getEventMeshTcpMonitor().getMq2EventMeshMsgNum().incrementAndGet();
                if (!header.getCommand().equals((Object)Command.REQUEST_TO_SERVER)) {
                    SessionSender.this.messageLogger.error("invalid message|messageHeader={}|msg={}", (Object)header, (Object)msg);
                    return;
                }
                Command cmd = Command.RESPONSE_TO_CLIENT;
                Package pkg = new Package();
                pkg.setHeader(new Header(cmd, OPStatus.SUCCESS.getCode().intValue(), null, seq));
                msg.getSystemProperties().put("rsp_eventMesh2c_timestamp", String.valueOf(System.currentTimeMillis()));
                try {
                    pkg.setBody((Object)EventMeshUtil.encodeMessage(msg));
                    pkg.setHeader(new Header(cmd, OPStatus.SUCCESS.getCode().intValue(), null, seq));
                }
                catch (Exception e) {
                    pkg.setHeader(new Header(cmd, OPStatus.FAIL.getCode().intValue(), null, seq));
                }
                finally {
                    Utils.writeAndFlush(pkg, startTime, taskExecuteTime, SessionSender.this.session.getContext(), SessionSender.this.session);
                }
            }

            public void onException(Throwable e) {
                SessionSender.this.messageLogger.error("exception occur while sending RR message|user={}", (Object)SessionSender.this.session.getClient(), (Object)new Exception(e));
            }
        };
    }
}

