/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.retry;

import io.openmessaging.api.Message;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubcriptionType;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshThreadFactoryImpl;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpRetryer {
    public static Logger logger = LoggerFactory.getLogger(EventMeshTcpRetryer.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private DelayQueue<DownStreamMsgContext> retrys = new DelayQueue();
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(3, 3, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000), new EventMeshThreadFactoryImpl("eventMesh-tcp-retry", true), new ThreadPoolExecutor.AbortPolicy());
    private Thread dispatcher;

    public EventMeshTcpRetryer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void pushRetry(DownStreamMsgContext downStreamMsgContext) {
        int maxRetryTimes;
        if (this.retrys.size() >= this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryQueueSize) {
            logger.error("pushRetry fail,retrys is too much,allow max retryQueueSize:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryQueueSize, downStreamMsgContext.retryTimes, downStreamMsgContext.seq, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            return;
        }
        int n = maxRetryTimes = SubcriptionType.SYNC.equals((Object)downStreamMsgContext.subscriptionItem.getType()) ? 1 : this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpMsgRetryTimes;
        if (downStreamMsgContext.retryTimes >= maxRetryTimes) {
            logger.warn("pushRetry fail,retry over maxRetryTimes:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{maxRetryTimes, downStreamMsgContext.retryTimes, downStreamMsgContext.seq, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            return;
        }
        this.retrys.offer(downStreamMsgContext);
        logger.info("pushRetry success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
    }

    public void init() {
        this.dispatcher = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DownStreamMsgContext downStreamMsgContext = null;
                    while ((downStreamMsgContext = (DownStreamMsgContext)EventMeshTcpRetryer.this.retrys.take()) != null) {
                        DownStreamMsgContext finalDownStreamMsgContext = downStreamMsgContext;
                        EventMeshTcpRetryer.this.pool.execute(() -> EventMeshTcpRetryer.this.retryHandle(finalDownStreamMsgContext));
                    }
                }
                catch (Exception e) {
                    logger.error("retry-dispatcher error!", (Throwable)e);
                }
            }
        }, "retry-dispatcher");
        this.dispatcher.setDaemon(true);
        logger.info("EventMeshTcpRetryer inited......");
    }

    private void retryHandle(DownStreamMsgContext downStreamMsgContext) {
        try {
            logger.info("retry downStream msg start,seq:{},retryTimes:{},bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            if (this.isRetryMsgTimeout(downStreamMsgContext)) {
                return;
            }
            ++downStreamMsgContext.retryTimes;
            downStreamMsgContext.lastPushTime = System.currentTimeMillis();
            Session rechoosen = null;
            String topic = downStreamMsgContext.msgExt.getSystemProperties("DESTINATION");
            rechoosen = !SubscriptionMode.BROADCASTING.equals((Object)downStreamMsgContext.subscriptionItem.getMode()) ? ((ClientGroupWrapper)downStreamMsgContext.session.getClientGroupWrapper().get()).getDownstreamDispatchStrategy().select(((ClientGroupWrapper)downStreamMsgContext.session.getClientGroupWrapper().get()).getSysId(), topic, ((ClientGroupWrapper)downStreamMsgContext.session.getClientGroupWrapper().get()).getGroupConsumerSessions()) : downStreamMsgContext.session;
            if (rechoosen == null) {
                logger.warn("retry, found no session to downstream msg,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            } else {
                downStreamMsgContext.session = rechoosen;
                rechoosen.downstreamMsg(downStreamMsgContext);
                logger.info("retry downStream msg end,seq:{},retryTimes:{},bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            }
        }
        catch (Exception e) {
            logger.error("retry-dispatcher error!", (Throwable)e);
        }
    }

    private boolean isRetryMsgTimeout(DownStreamMsgContext downStreamMsgContext) {
        String arriveTimeStr;
        long accessCost;
        boolean flag = false;
        String ttlStr = downStreamMsgContext.msgExt.getUserProperties("TTL");
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        String storeTimeStr = downStreamMsgContext.msgExt.getUserProperties("STORE_TIME");
        long storeTimestamp = StringUtils.isNumeric((CharSequence)storeTimeStr) ? Long.parseLong(storeTimeStr) : 0L;
        String leaveTimeStr = downStreamMsgContext.msgExt.getUserProperties("LEAVE_TIME");
        long brokerCost = StringUtils.isNumeric((CharSequence)leaveTimeStr) ? Long.parseLong(leaveTimeStr) - storeTimestamp : 0L;
        double elapseTime = brokerCost + (accessCost = StringUtils.isNumeric((CharSequence)(arriveTimeStr = downStreamMsgContext.msgExt.getUserProperties("ARRIVE_TIME"))) ? System.currentTimeMillis() - Long.parseLong(arriveTimeStr) : 0L);
        if (elapseTime >= (double)ttl) {
            logger.warn("discard the retry because timeout, seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt)});
            flag = true;
            this.eventMeshAckMsg(downStreamMsgContext);
        }
        return flag;
    }

    public void start() throws Exception {
        this.dispatcher.start();
        logger.info("EventMeshTcpRetryer started......");
    }

    public void shutdown() {
        this.pool.shutdown();
        logger.info("EventMeshTcpRetryer shutdown......");
    }

    public int getRetrySize() {
        return this.retrys.size();
    }

    private void eventMeshAckMsg(DownStreamMsgContext downStreamMsgContext) {
        ArrayList<Message> msgExts = new ArrayList<Message>();
        msgExts.add(downStreamMsgContext.msgExt);
        logger.warn("eventMeshAckMsg topic:{}, seq:{}, bizSeq:{}", new Object[]{downStreamMsgContext.msgExt.getSystemProperties("DESTINATION"), downStreamMsgContext.seq, downStreamMsgContext.msgExt.getSystemProperties("KEYS")});
        downStreamMsgContext.consumer.updateOffset(msgExts, downStreamMsgContext.consumeConcurrentlyContext);
    }

    public void printRetryThreadPoolState() {
    }
}

