/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.openmessaging.api.Message;
import java.util.ArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.ServerGlobal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownStreamMsgContext
implements Delayed {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public String seq = String.valueOf(ServerGlobal.getInstance().getMsgCounter().incrementAndGet());
    public Message msgExt;
    public Session session;
    public AbstractContext consumeConcurrentlyContext;
    public MQConsumerWrapper consumer;
    public int retryTimes;
    public SubscriptionItem subscriptionItem;
    private long executeTime;
    public long lastPushTime;
    private long createTime;
    private long expireTime;
    public boolean msgFromOtherEventMesh;

    public DownStreamMsgContext(Message msgExt, Session session, MQConsumerWrapper consumer, AbstractContext consumeConcurrentlyContext, boolean msgFromOtherEventMesh, SubscriptionItem subscriptionItem) {
        this.msgExt = msgExt;
        this.session = session;
        this.retryTimes = 0;
        this.consumer = consumer;
        this.consumeConcurrentlyContext = consumeConcurrentlyContext;
        this.lastPushTime = System.currentTimeMillis();
        this.executeTime = System.currentTimeMillis();
        this.createTime = System.currentTimeMillis();
        this.subscriptionItem = subscriptionItem;
        String ttlStr = msgExt.getUserProperties("TTL");
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        this.expireTime = System.currentTimeMillis() + ttl;
        this.msgFromOtherEventMesh = msgFromOtherEventMesh;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    public void ackMsg() {
        if (this.consumer != null && this.consumeConcurrentlyContext != null && this.msgExt != null) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            msgs.add(this.msgExt);
            this.consumer.updateOffset(msgs, this.consumeConcurrentlyContext);
            this.logger.info("ackMsg seq:{}, topic:{}, bizSeq:{}", new Object[]{this.seq, ((Message)msgs.get(0)).getSystemProperties("DESTINATION"), ((Message)msgs.get(0)).getSystemProperties("KEYS")});
        } else {
            this.logger.warn("ackMsg seq:{} failed,consumer is null:{}, context is null:{} , msgs is null:{}", new Object[]{this.seq, this.consumer == null, this.consumeConcurrentlyContext == null, this.msgExt == null});
        }
    }

    public void delay(long delay) {
        this.executeTime = System.currentTimeMillis() + (long)(this.retryTimes + 1) * delay;
    }

    public String toString() {
        return "DownStreamMsgContext{,seq=" + this.seq + ",client=" + (this.session == null ? null : this.session.getClient()) + ",retryTimes=" + this.retryTimes + ",consumer=" + this.consumer + ",topic=" + this.msgExt.getSystemProperties("DESTINATION") + ",subscriptionItem=" + this.subscriptionItem + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",lastPushTime=" + DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }

    @Override
    public int compareTo(Delayed delayed) {
        DownStreamMsgContext context = (DownStreamMsgContext)delayed;
        if (this.executeTime > context.executeTime) {
            return 1;
        }
        if (this.executeTime == context.executeTime) {
            return 0;
        }
        return -1;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.executeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

