/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.openmessaging.api.Message;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAckContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String seq;
    private AbstractContext context;
    private long createTime;
    private long expireTime;
    private List<Message> msgs;
    private MQConsumerWrapper consumer;

    public ClientAckContext(String seq, AbstractContext context, List<Message> msgs, MQConsumerWrapper consumer) {
        this.seq = seq;
        this.context = context;
        this.msgs = msgs;
        this.consumer = consumer;
        this.createTime = System.currentTimeMillis();
        String ttlStr = msgs.get(0).getUserProperties("TTL");
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        this.expireTime = System.currentTimeMillis() + ttl;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public AbstractContext getContext() {
        return this.context;
    }

    public void setContext(AbstractContext context) {
        this.context = context;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public List<Message> getMsgs() {
        return this.msgs;
    }

    public void setMsgs(List<Message> msgs) {
        this.msgs = msgs;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public MQConsumerWrapper getConsumer() {
        return this.consumer;
    }

    public void ackMsg() {
        if (this.consumer != null && this.context != null && this.msgs != null) {
            this.consumer.updateOffset(this.msgs, this.context);
            this.logger.info("ackMsg topic:{}, bizSeq:{}", (Object)this.msgs.get(0).getSystemProperties("DESTINATION"), (Object)EventMeshUtil.getMessageBizSeq(this.msgs.get(0)));
        } else {
            this.logger.warn("ackMsg failed,consumer is null:{}, context is null:{} , msgs is null:{}", new Object[]{this.consumer == null, this.context == null, this.msgs == null});
        }
    }

    public String toString() {
        return "ClientAckContext{,seq=" + this.seq + ",topic=" + (CollectionUtils.size(this.msgs) > 0 ? this.msgs.get(0).getSystemProperties("DESTINATION") : null) + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",expireTime=" + DateFormatUtils.format((long)this.expireTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }
}

