/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.group;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.ThreadUtil;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.DownstreamDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.FreePriorityDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionGroupMapping {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Logger sessionLogger = LoggerFactory.getLogger((String)"sessionLogger");
    private ConcurrentHashMap<InetSocketAddress, Session> sessionTable = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientGroupWrapper> clientGroupMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();
    private EventMeshTCPServer eventMeshTCPServer;

    public ClientSessionGroupMapping(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public ClientGroupWrapper getClientGroupWrapper(String sysId) {
        return (ClientGroupWrapper)MapUtils.getObject(this.clientGroupMap, (Object)sysId, null);
    }

    public Session getSession(ChannelHandlerContext ctx) {
        Session session = this.getSession((InetSocketAddress)ctx.channel().remoteAddress());
        return session;
    }

    public Session getSession(InetSocketAddress address) {
        return this.sessionTable.get(address);
    }

    public Session createSession(UserAgent user, ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress addr = (InetSocketAddress)ctx.channel().remoteAddress();
        user.setHost(addr.getHostString());
        user.setPort(addr.getPort());
        Session session = null;
        if (!this.sessionTable.containsKey(addr)) {
            this.logger.info("createSession client[{}]", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            session = new Session(user, ctx, this.eventMeshTCPServer.getEventMeshTCPConfiguration());
            this.initClientGroupWrapper(user, session);
            this.sessionTable.put(addr, session);
            this.sessionLogger.info("session|open|succeed|user={}", (Object)user);
        } else {
            session = this.sessionTable.get(addr);
            this.sessionLogger.error("session|open|failed|user={}|msg={}", (Object)user, (Object)"session has been created!");
        }
        return session;
    }

    public void readySession(Session session) throws Exception {
        if (!"sub".equals(session.getClient().getPurpose())) {
            throw new Exception("client purpose config is not sub");
        }
        this.startClientGroupConsumer(session);
    }

    public synchronized void closeSession(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress addr = (InetSocketAddress)ctx.channel().remoteAddress();
        Session session = (Session)MapUtils.getObject(this.sessionTable, (Object)addr, null);
        if (session == null) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            this.logger.info("begin to close channel to remote address[{}]", (Object)remoteAddress);
            ctx.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ClientSessionGroupMapping.this.logger.info("close the connection to remote address[{}] result: {}", (Object)remoteAddress, (Object)future.isSuccess());
                }
            });
            this.sessionLogger.info("session|close|succeed|address={}|msg={}", (Object)addr, (Object)"no session was found");
            return;
        }
        this.closeSession(session);
        this.sessionTable.remove(addr);
        this.sessionLogger.info("session|close|succeed|user={}", (Object)session.getClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(Session session) throws Exception {
        final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(session.getContext().channel());
        if (SessionState.CLOSED == session.getSessionState()) {
            this.logger.info("session has been closed, addr:{}", (Object)remoteAddress);
            return;
        }
        Session session2 = session;
        synchronized (session2) {
            if (SessionState.CLOSED == session.getSessionState()) {
                this.logger.info("session has been closed in sync, addr:{}", (Object)remoteAddress);
                return;
            }
            session.setSessionState(SessionState.CLOSED);
            if ("sub".equals(session.getClient().getPurpose())) {
                this.cleanClientGroupWrapperByCloseSub(session);
            } else if ("pub".equals(session.getClient().getPurpose())) {
                this.cleanClientGroupWrapperByClosePub(session);
            } else {
                this.logger.error("client purpose config is error:{}", (Object)session.getClient().getPurpose());
            }
            if (session.getContext() != null) {
                this.logger.info("begin to close channel to remote address[{}]", (Object)remoteAddress);
                session.getContext().channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ClientSessionGroupMapping.this.logger.info("close the connection to remote address[{}] result: {}", (Object)remoteAddress, (Object)future.isSuccess());
                    }
                });
            }
        }
    }

    private ClientGroupWrapper constructClientGroupWrapper(String sysId, String producerGroup, String consumerGroup, EventMeshTCPServer eventMeshTCPServer, DownstreamDispatchStrategy downstreamDispatchStrategy) {
        return new ClientGroupWrapper(sysId, producerGroup, consumerGroup, eventMeshTCPServer, downstreamDispatchStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClientGroupWrapper(UserAgent user, Session session) throws Exception {
        Object obj;
        if (!this.lockMap.containsKey(user.getSubsystem()) && (obj = this.lockMap.putIfAbsent(user.getSubsystem(), new Object())) == null) {
            this.logger.info("add lock to map for subsystem:{}", (Object)user.getSubsystem());
        }
        Object object = this.lockMap.get(user.getSubsystem());
        synchronized (object) {
            ClientGroupWrapper cgw;
            if (!this.clientGroupMap.containsKey(user.getSubsystem())) {
                cgw = this.constructClientGroupWrapper(user.getSubsystem(), user.getProducerGroup(), user.getConsumerGroup(), this.eventMeshTCPServer, new FreePriorityDispatchStrategy());
                this.clientGroupMap.put(user.getSubsystem(), cgw);
                this.logger.info("create new ClientGroupWrapper, subsystem:{}", (Object)user.getSubsystem());
            }
            cgw = this.clientGroupMap.get(user.getSubsystem());
            if ("pub".equals(user.getPurpose())) {
                this.startClientGroupProducer(cgw, session);
            } else if ("sub".equals(user.getPurpose())) {
                this.initClientGroupConsumser(cgw);
            } else {
                this.logger.error("unknown client purpose:{}", (Object)user.getPurpose());
                throw new Exception("client purpose config is error");
            }
            session.setClientGroupWrapper(new WeakReference<ClientGroupWrapper>(cgw));
        }
    }

    private void startClientGroupProducer(ClientGroupWrapper cgw, Session session) throws Exception {
        boolean flag;
        if (!cgw.producerStarted.get()) {
            cgw.startClientGroupProducer();
        }
        if (!(flag = cgw.addGroupProducerSession(session))) {
            throw new Exception("addGroupProducerSession fail");
        }
        session.setSessionState(SessionState.RUNNING);
    }

    private void initClientGroupConsumser(ClientGroupWrapper cgw) throws Exception {
        if (!cgw.producerStarted.get()) {
            cgw.startClientGroupProducer();
        }
        if (!cgw.inited4Broadcast.get()) {
            cgw.initClientGroupBroadcastConsumer();
        }
        if (!cgw.inited4Persistent.get()) {
            cgw.initClientGroupPersistentConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startClientGroupConsumer(Session session) throws Exception {
        if (!this.lockMap.containsKey(session.getClient().getSubsystem())) {
            this.lockMap.putIfAbsent(session.getClient().getSubsystem(), new Object());
        }
        Object object = this.lockMap.get(session.getClient().getSubsystem());
        synchronized (object) {
            this.logger.info("readySession session[{}]", (Object)session);
            ClientGroupWrapper cgw = (ClientGroupWrapper)session.getClientGroupWrapper().get();
            boolean flag = cgw.addGroupConsumerSession(session);
            if (!flag) {
                throw new Exception("addGroupConsumerSession fail");
            }
            if (cgw.inited4Persistent.get() && !cgw.started4Persistent.get()) {
                cgw.startClientGroupPersistentConsumer();
            }
            if (cgw.inited4Broadcast.get() && !cgw.started4Broadcast.get()) {
                cgw.startClientGroupBroadcastConsumer();
            }
            session.setSessionState(SessionState.RUNNING);
        }
    }

    private void cleanClientGroupWrapperByCloseSub(Session session) throws Exception {
        this.cleanSubscriptionInSession(session);
        ((ClientGroupWrapper)session.getClientGroupWrapper().get()).removeGroupConsumerSession(session);
        this.handleUnackMsgsInSession(session);
        this.cleanClientGroupWrapperCommon(session);
    }

    private void cleanClientGroupWrapperByClosePub(Session session) throws Exception {
        ((ClientGroupWrapper)session.getClientGroupWrapper().get()).removeGroupProducerSession(session);
        this.cleanClientGroupWrapperCommon(session);
    }

    private void cleanSubscriptionInSession(Session session) throws Exception {
        for (SubscriptionItem item : session.getSessionContext().subscribeTopics.values()) {
            ((ClientGroupWrapper)session.getClientGroupWrapper().get()).removeSubscription(item.getTopic(), session);
            if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).hasSubscription(item.getTopic())) continue;
            ((ClientGroupWrapper)session.getClientGroupWrapper().get()).unsubscribe(item);
        }
    }

    private void handleUnackMsgsInSession(Session session) {
        ConcurrentHashMap<String, DownStreamMsgContext> unAckMsg = session.getPusher().getUnAckMsg();
        if (unAckMsg.size() > 0 && ((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupConsumerSessions().size() > 0) {
            for (Map.Entry<String, DownStreamMsgContext> entry : unAckMsg.entrySet()) {
                DownStreamMsgContext downStreamMsgContext = entry.getValue();
                if (SubscriptionMode.BROADCASTING.equals((Object)downStreamMsgContext.subscriptionItem.getMode())) {
                    this.logger.warn("exist broadcast msg unack when closeSession,seq:{},bizSeq:{},client:{}", new Object[]{downStreamMsgContext.seq, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.msgExt), session.getClient()});
                    continue;
                }
                Session reChooseSession = ((ClientGroupWrapper)session.getClientGroupWrapper().get()).getDownstreamDispatchStrategy().select(((ClientGroupWrapper)session.getClientGroupWrapper().get()).getConsumerGroup(), downStreamMsgContext.msgExt.getTopic(), ((ClientGroupWrapper)session.getClientGroupWrapper().get()).groupConsumerSessions);
                if (reChooseSession != null) {
                    downStreamMsgContext.session = reChooseSession;
                    reChooseSession.downstreamMsg(downStreamMsgContext);
                    this.logger.info("rePush msg form unAckMsgs,seq:{},rePushClient:{}", (Object)entry.getKey(), (Object)downStreamMsgContext.session.getClient());
                    continue;
                }
                this.logger.warn("select session fail in handleUnackMsgsInSession,seq:{},topic:{}", (Object)entry.getKey(), (Object)downStreamMsgContext.msgExt.getTopic());
            }
        }
    }

    private void cleanClientGroupWrapperCommon(Session session) throws Exception {
        this.logger.info("GroupConsumerSessions size:{}", (Object)((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupConsumerSessions().size());
        if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupConsumerSessions().size() == 0) {
            this.shutdownClientGroupConsumer(session);
        }
        this.logger.info("GroupProducerSessions size:{}", (Object)((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupProducerSessions().size());
        if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupConsumerSessions().size() == 0 && ((ClientGroupWrapper)session.getClientGroupWrapper().get()).getGroupProducerSessions().size() == 0) {
            this.shutdownClientGroupProducer(session);
            this.clientGroupMap.remove(((ClientGroupWrapper)session.getClientGroupWrapper().get()).getSysId());
            this.lockMap.remove(((ClientGroupWrapper)session.getClientGroupWrapper().get()).getSysId());
            this.logger.info("remove clientGroupWrapper subsystem[{}]", (Object)((ClientGroupWrapper)session.getClientGroupWrapper().get()).getSysId());
        }
    }

    private void shutdownClientGroupConsumer(Session session) throws Exception {
        if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).started4Broadcast.get() == Boolean.TRUE.booleanValue()) {
            ((ClientGroupWrapper)session.getClientGroupWrapper().get()).shutdownBroadCastConsumer();
        }
        if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).started4Persistent.get() == Boolean.TRUE.booleanValue()) {
            ((ClientGroupWrapper)session.getClientGroupWrapper().get()).shutdownPersistentConsumer();
        }
    }

    private void shutdownClientGroupProducer(Session session) throws Exception {
        if (((ClientGroupWrapper)session.getClientGroupWrapper().get()).producerStarted.get() == Boolean.TRUE.booleanValue()) {
            ((ClientGroupWrapper)session.getClientGroupWrapper().get()).shutdownProducer();
        }
    }

    private void initSessionCleaner() {
        this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Session tmp : ClientSessionGroupMapping.this.sessionTable.values()) {
                    if (System.currentTimeMillis() - tmp.getLastHeartbeatTime() <= (long)((ClientSessionGroupMapping)ClientSessionGroupMapping.this).eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpSessionExpiredInMills) continue;
                    try {
                        ClientSessionGroupMapping.this.logger.warn("clean expired session,client:{}", (Object)tmp.getClient());
                        ClientSessionGroupMapping.this.closeSession(tmp.getContext());
                    }
                    catch (Exception e) {
                        ClientSessionGroupMapping.this.logger.error("say goodbye to session error! {}", (Object)tmp, (Object)e);
                    }
                }
            }
        }, 1000L, this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshTcpSessionExpiredInMills, TimeUnit.MILLISECONDS);
    }

    private void initDownStreamMsgContextCleaner() {
        this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Session tmp : ClientSessionGroupMapping.this.sessionTable.values()) {
                    for (Map.Entry<String, DownStreamMsgContext> entry : tmp.getPusher().getUnAckMsg().entrySet()) {
                        String seqKey = entry.getKey();
                        DownStreamMsgContext downStreamMsgContext = entry.getValue();
                        if (!downStreamMsgContext.isExpire()) continue;
                        downStreamMsgContext.ackMsg();
                        tmp.getPusher().getUnAckMsg().remove(seqKey);
                        ClientSessionGroupMapping.this.logger.warn("remove expire downStreamMsgContext, session:{}, topic:{}, seq:{}", new Object[]{tmp, downStreamMsgContext.msgExt.getSystemProperties("DESTINATION"), seqKey});
                    }
                }
            }
        }, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void init() throws Exception {
        this.initSessionCleaner();
        this.initDownStreamMsgContextCleaner();
        this.logger.info("ClientSessionGroupMapping inited......");
    }

    public void start() throws Exception {
        this.logger.info("ClientSessionGroupMapping started......");
    }

    public void shutdown() throws Exception {
        this.logger.info("begin to close sessions gracefully");
        this.sessionTable.values().parallelStream().forEach(itr -> {
            try {
                EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, itr, this);
            }
            catch (Exception e) {
                this.logger.error("say goodbye to session error! {}", itr, (Object)e);
            }
        });
        ThreadUtil.randomSleep((int)50);
        this.logger.info("ClientSessionGroupMapping shutdown......");
    }

    public ConcurrentHashMap<InetSocketAddress, Session> getSessionMap() {
        return this.sessionTable;
    }

    public ConcurrentHashMap<String, ClientGroupWrapper> getClientGroupMap() {
        return this.clientGroupMap;
    }

    public Map<String, Map<String, Integer>> prepareEventMeshClientDistributionData() {
        HashMap result = null;
        if (!this.clientGroupMap.isEmpty()) {
            result = new HashMap();
            for (Map.Entry<String, ClientGroupWrapper> entry : this.clientGroupMap.entrySet()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("sub", entry.getValue().getGroupConsumerSessions().size());
                map.put("pub", entry.getValue().getGroupProducerSessions().size());
                result.put(entry.getKey(), map);
            }
        }
        return result;
    }
}

