/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HTTPClientPool {
    private List<CloseableHttpClient> clients = Lists.newArrayList();
    private int core = 1;

    public HTTPClientPool(int core) {
        this.core = core;
    }

    public CloseableHttpClient getClient() {
        if (CollectionUtils.size(this.clients) < this.core) {
            CloseableHttpClient client = HttpClients.createDefault();
            this.clients.add(client);
            return client;
        }
        return this.clients.get(RandomUtils.nextInt((int)this.core, (int)(2 * this.core)) % this.core);
    }

    public void shutdown() throws Exception {
        Iterator<CloseableHttpClient> itr = this.clients.iterator();
        while (itr.hasNext()) {
            CloseableHttpClient client = itr.next();
            client.close();
            itr.remove();
        }
    }
}

