/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.protocol.SubcriptionType;
import org.apache.eventmesh.common.protocol.http.common.ClientRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.AbstractHTTPPushRequest;
import org.apache.eventmesh.runtime.util.OMSUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHTTPPushRequest
extends AbstractHTTPPushRequest {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Set<AbstractHTTPPushRequest>> waitingRequests;
    public String currPushUrl;
    private static final RandomStringGenerator randomGenerator = new RandomStringGenerator.Builder().withinRange(48, 57).build();

    public AsyncHTTPPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractHTTPPushRequest>> waitingRequests) {
        super(handleMsgContext);
        this.waitingRequests = waitingRequests;
    }

    @Override
    public void tryHTTPRequest() {
        block13: {
            this.currPushUrl = this.getUrl();
            if (StringUtils.isBlank((CharSequence)this.currPushUrl)) {
                return;
            }
            HttpPost builder = new HttpPost(this.currPushUrl);
            String requestCode = "";
            requestCode = SubcriptionType.SYNC.equals((Object)this.handleMsgContext.getSubscriptionItem().getType()) ? String.valueOf(RequestCode.HTTP_PUSH_CLIENT_SYNC.getRequestCode()) : String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode());
            builder.addHeader("Code", requestCode);
            builder.addHeader("Language", "JAVA");
            builder.addHeader("Version", ProtocolVersion.V1.getVersion());
            builder.addHeader("EventMeshCluster", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().eventMeshCluster);
            builder.addHeader("EventMeshIp", IPUtil.getLocalAddress());
            builder.addHeader("EventMeshEnv", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().eventMeshEnv);
            builder.addHeader("EventMeshIdc", this.handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration().eventMeshIDC);
            this.handleMsgContext.getMsg().getUserProperties().put("req_eventMesh2c_timestamp", String.valueOf(System.currentTimeMillis()));
            String content = "";
            try {
                content = new String(this.handleMsgContext.getMsg().getBody(), "UTF-8");
            }
            catch (Exception ex) {
                return;
            }
            ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
            body.add(new BasicNameValuePair("content", content));
            if (StringUtils.isBlank((CharSequence)this.handleMsgContext.getBizSeqNo())) {
                body.add(new BasicNameValuePair("bizSeqNo", randomGenerator.generate(20)));
            } else {
                body.add(new BasicNameValuePair("bizSeqNo", this.handleMsgContext.getBizSeqNo()));
            }
            if (StringUtils.isBlank((CharSequence)this.handleMsgContext.getUniqueId())) {
                body.add(new BasicNameValuePair("uniqueId", randomGenerator.generate(20)));
            } else {
                body.add(new BasicNameValuePair("uniqueId", this.handleMsgContext.getUniqueId()));
            }
            body.add(new BasicNameValuePair("randomNo", this.handleMsgContext.getMsgRandomNo()));
            body.add(new BasicNameValuePair("topic", this.handleMsgContext.getTopic()));
            body.add(new BasicNameValuePair("extFields", JSON.toJSONString(OMSUtil.getMessageProp(this.handleMsgContext.getMsg()))));
            try {
                builder.setEntity((HttpEntity)new UrlEncodedFormEntity(body));
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordPushMsg();
            this.lastPushTime = System.currentTimeMillis();
            this.addToWaitingMap(this);
            this.cmdLogger.info("cmd={}|eventMesh2client|from={}|to={}", new Object[]{requestCode, IPUtil.getLocalAddress(), this.currPushUrl});
            try {
                httpClientPool.getClient().execute((HttpUriRequest)builder, (ResponseHandler)new ResponseHandler<Object>(){

                    public Object handleResponse(HttpResponse response) {
                        AsyncHTTPPushRequest.this.removeWaitingMap(AsyncHTTPPushRequest.this);
                        long cost = System.currentTimeMillis() - AsyncHTTPPushRequest.this.lastPushTime;
                        AsyncHTTPPushRequest.this.eventMeshHTTPServer.metrics.summaryMetrics.recordHTTPPushTimeCost(cost);
                        if (response.getStatusLine().getStatusCode() != 200) {
                            AsyncHTTPPushRequest.this.eventMeshHTTPServer.metrics.summaryMetrics.recordHttpPushMsgFailed();
                            AsyncHTTPPushRequest.this.messageLogger.info("message|eventMesh2client|exception|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{AsyncHTTPPushRequest.this.currPushUrl, AsyncHTTPPushRequest.this.handleMsgContext.getTopic(), AsyncHTTPPushRequest.this.handleMsgContext.getBizSeqNo(), AsyncHTTPPushRequest.this.handleMsgContext.getUniqueId(), cost});
                            AsyncHTTPPushRequest.this.delayRetry();
                            if (AsyncHTTPPushRequest.this.isComplete()) {
                                AsyncHTTPPushRequest.this.handleMsgContext.finish();
                            }
                        } else {
                            String res = "";
                            try {
                                res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                            }
                            catch (IOException e) {
                                AsyncHTTPPushRequest.this.handleMsgContext.finish();
                                return new Object();
                            }
                            ClientRetCode result = AsyncHTTPPushRequest.this.processResponseContent(res);
                            AsyncHTTPPushRequest.this.messageLogger.info("message|eventMesh2client|{}|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{result, AsyncHTTPPushRequest.this.currPushUrl, AsyncHTTPPushRequest.this.handleMsgContext.getTopic(), AsyncHTTPPushRequest.this.handleMsgContext.getBizSeqNo(), AsyncHTTPPushRequest.this.handleMsgContext.getUniqueId(), cost});
                            if (result == ClientRetCode.OK) {
                                AsyncHTTPPushRequest.this.complete();
                                if (AsyncHTTPPushRequest.this.isComplete()) {
                                    AsyncHTTPPushRequest.this.handleMsgContext.finish();
                                }
                            } else if (result == ClientRetCode.RETRY) {
                                AsyncHTTPPushRequest.this.delayRetry();
                                if (AsyncHTTPPushRequest.this.isComplete()) {
                                    AsyncHTTPPushRequest.this.handleMsgContext.finish();
                                }
                            } else if (result == ClientRetCode.NOLISTEN) {
                                AsyncHTTPPushRequest.this.delayRetry();
                                if (AsyncHTTPPushRequest.this.isComplete()) {
                                    AsyncHTTPPushRequest.this.handleMsgContext.finish();
                                }
                            } else if (result == ClientRetCode.FAIL) {
                                AsyncHTTPPushRequest.this.complete();
                                if (AsyncHTTPPushRequest.this.isComplete()) {
                                    AsyncHTTPPushRequest.this.handleMsgContext.finish();
                                }
                            }
                        }
                        return new Object();
                    }
                });
                if (this.messageLogger.isDebugEnabled()) {
                    this.messageLogger.debug("message|eventMesh2client|url={}|topic={}|msg={}", new Object[]{this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getMsg()});
                } else {
                    this.messageLogger.info("message|eventMesh2client|url={}|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{this.currPushUrl, this.handleMsgContext.getTopic(), this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId()});
                }
            }
            catch (IOException e) {
                this.messageLogger.error("push2client err", (Throwable)e);
                this.removeWaitingMap(this);
                this.delayRetry();
                if (!this.isComplete()) break block13;
                this.handleMsgContext.finish();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("asyncPushRequest={").append("bizSeqNo=").append(this.handleMsgContext.getBizSeqNo()).append(",startIdx=").append(this.startIdx).append(",retryTimes=").append(this.retryTimes).append(",uniqueId=").append(this.handleMsgContext.getUniqueId()).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",lastPushTime=").append(DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    ClientRetCode processResponseContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return ClientRetCode.FAIL;
        }
        try {
            JSONObject ret = JSONObject.parseObject((String)content);
            Integer retCode = ret.getInteger("retCode");
            if (retCode != null && ClientRetCode.contains((Integer)retCode)) {
                return ClientRetCode.get((Integer)retCode);
            }
            return ClientRetCode.FAIL;
        }
        catch (NumberFormatException e) {
            this.messageLogger.warn("url:{}, bizSeqno:{}, uniqueId:{}, httpResponse:{}", new Object[]{this.currPushUrl, this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), content});
            return ClientRetCode.FAIL;
        }
        catch (JSONException e) {
            this.messageLogger.warn("url:{}, bizSeqno:{}, uniqueId:{},  httpResponse:{}", new Object[]{this.currPushUrl, this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), content});
            return ClientRetCode.FAIL;
        }
        catch (Throwable t) {
            this.messageLogger.warn("url:{}, bizSeqno:{}, uniqueId:{},  httpResponse:{}", new Object[]{this.currPushUrl, this.handleMsgContext.getBizSeqNo(), this.handleMsgContext.getUniqueId(), content});
            return ClientRetCode.FAIL;
        }
    }

    private void addToWaitingMap(AsyncHTTPPushRequest request) {
        if (this.waitingRequests.containsKey(request.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).add(request);
            return;
        }
        this.waitingRequests.put(request.handleMsgContext.getConsumerGroup(), Sets.newConcurrentHashSet());
        this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).add(request);
    }

    private void removeWaitingMap(AsyncHTTPPushRequest request) {
        if (this.waitingRequests.containsKey(request.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(request.handleMsgContext.getConsumerGroup()).remove(request);
            return;
        }
    }

    @Override
    public boolean retry() {
        this.tryHTTPRequest();
        return true;
    }
}

