/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import io.openmessaging.api.Message;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageContext
extends RetryContext {
    public static Logger logger = LoggerFactory.getLogger((String)"retry");
    private Message msg;
    private String bizSeqNo;
    private EventMeshProducer eventMeshProducer;
    private long createTime = System.currentTimeMillis();
    private Map<String, String> props;
    public EventMeshHTTPServer eventMeshHTTPServer;
    private List<Message> messageList;

    public SendMessageContext(String bizSeqNo, Message msg, EventMeshProducer eventMeshProducer, EventMeshHTTPServer eventMeshHTTPServer) {
        this.bizSeqNo = bizSeqNo;
        this.msg = msg;
        this.eventMeshProducer = eventMeshProducer;
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void addProp(String key, String val) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, val);
    }

    public String getProp(String key) {
        return this.props.get(key);
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public Message getMsg() {
        return this.msg;
    }

    public void setMsg(Message msg) {
        this.msg = msg;
    }

    public EventMeshProducer getEventMeshProducer() {
        return this.eventMeshProducer;
    }

    public void setEventMeshProducer(EventMeshProducer eventMeshProducer) {
        this.eventMeshProducer = eventMeshProducer;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageContext={").append("bizSeqNo=").append(this.bizSeqNo).append(",retryTimes=").append(this.retryTimes).append(",producer=").append(this.eventMeshProducer != null ? this.eventMeshProducer.producerGroupConfig.getGroupName() : null).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    @Override
    public boolean retry() throws Exception {
        if (this.eventMeshProducer == null) {
            return false;
        }
        if (this.retryTimes > 0) {
            return false;
        }
        ++this.retryTimes;
        this.eventMeshProducer.send(this, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                logger.warn("", (Throwable)context.getException());
                SendMessageContext.this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendBatchMsgFailed(1L);
            }
        });
        return true;
    }
}

