/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import io.openmessaging.api.Message;
import io.openmessaging.api.SendCallback;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.RRCallback;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ProducerGroupConf;
import org.apache.eventmesh.runtime.core.plugin.MQProducerWrapper;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshProducer {
    protected AtomicBoolean started = new AtomicBoolean(Boolean.FALSE);
    protected AtomicBoolean inited = new AtomicBoolean(Boolean.FALSE);
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ProducerGroupConf producerGroupConfig;
    protected EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    protected MQProducerWrapper mqProducerWrapper = new MQProducerWrapper();

    public AtomicBoolean getInited() {
        return this.inited;
    }

    public AtomicBoolean getStarted() {
        return this.started;
    }

    public void send(SendMessageContext sendMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.send(sendMsgContext.getMsg(), sendCallback);
    }

    public void request(SendMessageContext sendMsgContext, SendCallback sendCallback, RRCallback rrCallback, long timeout) throws Exception {
        this.mqProducerWrapper.request(sendMsgContext.getMsg(), sendCallback, rrCallback, timeout);
    }

    public Message request(SendMessageContext sendMessageContext, long timeout) throws Exception {
        return this.mqProducerWrapper.request(sendMessageContext.getMsg(), timeout);
    }

    public boolean reply(SendMessageContext sendMsgContext, SendCallback sendCallback) throws Exception {
        this.mqProducerWrapper.reply(sendMsgContext.getMsg(), sendCallback);
        return true;
    }

    public MQProducerWrapper getMqProducerWrapper() {
        return this.mqProducerWrapper;
    }

    public synchronized void init(EventMeshHTTPConfiguration eventMeshHttpConfiguration, ProducerGroupConf producerGroupConfig) throws Exception {
        this.producerGroupConfig = producerGroupConfig;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        Properties keyValue = new Properties();
        keyValue.put("producerGroup", producerGroupConfig.getGroupName());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(producerGroupConfig.getGroupName(), eventMeshHttpConfiguration.eventMeshCluster));
        keyValue.put("eventMeshIDC", eventMeshHttpConfiguration.eventMeshIDC);
        this.mqProducerWrapper.init(keyValue);
        this.inited.compareAndSet(false, true);
        this.logger.info("EventMeshProducer [{}] inited.............", (Object)producerGroupConfig.getGroupName());
    }

    public synchronized void start() throws Exception {
        if (this.started.get()) {
            return;
        }
        this.mqProducerWrapper.start();
        this.started.compareAndSet(false, true);
        this.logger.info("EventMeshProducer [{}] started.............", (Object)this.producerGroupConfig.getGroupName());
    }

    public synchronized void shutdown() throws Exception {
        if (!this.inited.get()) {
            return;
        }
        if (!this.started.get()) {
            return;
        }
        this.mqProducerWrapper.shutdown();
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
        this.logger.info("EventMeshProducer [{}] shutdown.............", (Object)this.producerGroupConfig.getGroupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("eventMeshProducer={").append("inited=").append(this.inited.get()).append(",").append("started=").append(this.started.get()).append(",").append("producerGroupConfig=").append(this.producerGroupConfig).append("}");
        return sb.toString();
    }
}

