/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeResponseHeader;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor
implements HttpRequestProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public SubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.httpLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtil.getLocalAddress()});
        SubscribeRequestHeader subscribeRequestHeader = (SubscribeRequestHeader)asyncContext.getRequest().getHeader();
        SubscribeRequestBody subscribeRequestBody = (SubscribeRequestBody)asyncContext.getRequest().getBody();
        SubscribeResponseHeader subscribeResponseHeader = SubscribeResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtil.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)subscribeRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)subscribeRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)subscribeRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)subscribeRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)subscribeRequestBody.getUrl()) || CollectionUtils.isEmpty((Collection)subscribeRequestBody.getTopics()) || StringUtils.isBlank((CharSequence)subscribeRequestBody.getConsumerGroup())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        List subTopicList = subscribeRequestBody.getTopics();
        String url = subscribeRequestBody.getUrl();
        String consumerGroup = subscribeRequestBody.getConsumerGroup();
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            this.registerClient(subscribeRequestHeader, consumerGroup, subTopicList, url);
            for (SubscriptionItem subTopic : subTopicList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.localClientInfoMapping.get(consumerGroup + "@" + subTopic.getTopic());
                if (CollectionUtils.isEmpty(groupTopicClients)) {
                    this.httpLogger.error("group {} topic {} clients is empty", (Object)consumerGroup, (Object)subTopic);
                }
                HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                for (Client client : groupTopicClients) {
                    if (idcUrls.containsKey(client.idc)) {
                        ((List)idcUrls.get(client.idc)).add(StringUtils.deleteWhitespace((String)client.url));
                        continue;
                    }
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(client.url);
                    idcUrls.put(client.idc, urls);
                }
                ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup);
                if (consumerGroupConf == null) {
                    consumerGroupConf = new ConsumerGroupConf(consumerGroup);
                    ConsumerGroupTopicConf consumeTopicConfig = new ConsumerGroupTopicConf();
                    consumeTopicConfig.setConsumerGroup(consumerGroup);
                    consumeTopicConfig.setTopic(subTopic.getTopic());
                    consumeTopicConfig.setSubscriptionItem(subTopic);
                    consumeTopicConfig.setUrls(new HashSet<String>(Arrays.asList(url)));
                    consumeTopicConfig.setIdcUrls(idcUrls);
                    HashMap<String, ConsumerGroupTopicConf> map = new HashMap<String, ConsumerGroupTopicConf>();
                    map.put(subTopic.getTopic(), consumeTopicConfig);
                    consumerGroupConf.setConsumerGroupTopicConf(map);
                } else {
                    Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                    for (String key : map.keySet()) {
                        if (!StringUtils.equals((CharSequence)subTopic.getTopic(), (CharSequence)key)) continue;
                        ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                        ConsumerGroupTopicConf currentTopicConf = map.get(key);
                        latestTopicConf.setConsumerGroup(consumerGroup);
                        latestTopicConf.setTopic(subTopic.getTopic());
                        latestTopicConf.setSubscriptionItem(subTopic);
                        latestTopicConf.setUrls(new HashSet<String>(Arrays.asList(url)));
                        latestTopicConf.getUrls().addAll(currentTopicConf.getUrls());
                        latestTopicConf.setIdcUrls(idcUrls);
                        map.put(key, latestTopicConf);
                    }
                }
                this.eventMeshHTTPServer.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
            }
            long startTime = System.currentTimeMillis();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup), this.eventMeshHTTPServer.localConsumerGroupMapping);
                CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

                    @Override
                    public void onResponse(HttpCommand httpCommand) {
                        try {
                            if (SubscribeProcessor.this.httpLogger.isDebugEnabled()) {
                                SubscribeProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                            }
                            SubscribeProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                            ((SubscribeProcessor)SubscribeProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS.getRetCode(), EventMeshRetCode.SUCCESS.getErrMsg());
                asyncContext.onComplete(responseEventMeshCommand, handler);
            }
            catch (Exception e) {
                HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)subscribeResponseHeader, (Body)SubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                asyncContext.onComplete(err);
                long endTime = System.currentTimeMillis();
                this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JSONObject.toJSONString((Object)subscribeRequestBody.getTopics()), subscribeRequestBody.getUrl(), e});
                this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgFailed();
                this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgCost(endTime - startTime);
            }
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private void registerClient(SubscribeRequestHeader subscribeRequestHeader, String consumerGroup, List<SubscriptionItem> subscriptionItems, String url) {
        for (SubscriptionItem item : subscriptionItems) {
            Client client = new Client();
            client.env = subscribeRequestHeader.getEnv();
            client.idc = subscribeRequestHeader.getIdc();
            client.sys = subscribeRequestHeader.getSys();
            client.ip = subscribeRequestHeader.getIp();
            client.pid = subscribeRequestHeader.getPid();
            client.consumerGroup = consumerGroup;
            client.topic = item.getTopic();
            client.url = url;
            client.lastUpTime = new Date();
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (this.eventMeshHTTPServer.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)client.url)) continue;
                    isContains = true;
                    localClient.lastUpTime = client.lastUpTime;
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }
}

