/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.ChannelHandlerContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.RRCallback;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.LiteMessage;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageResponseHeader;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.OMSUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSyncMessageProcessor
implements HttpRequestProcessor {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public SendSyncMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtil.getLocalAddress()});
        SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)asyncContext.getRequest().getHeader();
        final SendMessageRequestBody sendMessageRequestBody = (SendMessageRequestBody)asyncContext.getRequest().getBody();
        final SendMessageResponseHeader sendMessageResponseHeader = SendMessageResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtil.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)sendMessageRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)sendMessageRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)sendMessageRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)sendMessageRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)sendMessageRequestBody.getBizSeqNo()) || StringUtils.isBlank((CharSequence)sendMessageRequestBody.getUniqueId()) || StringUtils.isBlank((CharSequence)sendMessageRequestBody.getProducerGroup()) || StringUtils.isBlank((CharSequence)sendMessageRequestBody.getTopic()) || StringUtils.isBlank((CharSequence)sendMessageRequestBody.getContent()) || StringUtils.isBlank((CharSequence)sendMessageRequestBody.getTtl())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String producerGroup = sendMessageRequestBody.getProducerGroup();
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String ttl = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
        if (StringUtils.isNotBlank((CharSequence)sendMessageRequestBody.getTtl()) && StringUtils.isNumeric((CharSequence)sendMessageRequestBody.getTtl())) {
            ttl = sendMessageRequestBody.getTtl();
        }
        Message omsMsg = new Message();
        try {
            omsMsg.setBody(sendMessageRequestBody.getContent().getBytes("UTF-8"));
            omsMsg.setTopic(sendMessageRequestBody.getTopic());
            omsMsg.putSystemProperties("DESTINATION", sendMessageRequestBody.getTopic());
            if (!StringUtils.isBlank((CharSequence)sendMessageRequestBody.getTag())) {
                omsMsg.putUserProperties("Tag", sendMessageRequestBody.getTag());
            }
            omsMsg.putSystemProperties("TIMEOUT", ttl);
            omsMsg.putSystemProperties("SEARCH_KEYS", sendMessageRequestBody.getBizSeqNo());
            omsMsg.putUserProperties("msgType", "persistent");
            omsMsg.putUserProperties("req_c2eventMesh_timestamp", String.valueOf(System.currentTimeMillis()));
            omsMsg.putUserProperties("RMB_UNIQ_ID", sendMessageRequestBody.getUniqueId());
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)sendMessageRequestBody.getBizSeqNo(), (Object)sendMessageRequestBody.getTopic());
            }
            omsMsg.putUserProperties("req_eventMesh2mq_timestamp", String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getTopic(), e});
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        SendMessageContext sendMessageContext = new SendMessageContext(sendMessageRequestBody.getBizSeqNo(), omsMsg, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsg();
        final long startTime = System.currentTimeMillis();
        final CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

            @Override
            public void onResponse(HttpCommand httpCommand) {
                try {
                    if (SendSyncMessageProcessor.this.httpLogger.isDebugEnabled()) {
                        SendSyncMessageProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                    }
                    SendSyncMessageProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    ((SendSyncMessageProcessor)SendSyncMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        LiteMessage liteMessage = new LiteMessage(sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId(), sendMessageRequestBody.getTopic(), sendMessageRequestBody.getContent()).setProp((Map)sendMessageRequestBody.getExtFields());
        try {
            eventMeshProducer.request(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    long endTime = System.currentTimeMillis();
                    ((SendSyncMessageProcessor)SendSyncMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgCost(endTime - startTime);
                    SendSyncMessageProcessor.this.messageLogger.info("message|eventMesh2mq|REQ|SYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, sendMessageRequestBody.getTopic(), sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId()});
                }

                public void onException(OnExceptionContext context) {
                    HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                    asyncContext.onComplete(err, handler);
                    long endTime = System.currentTimeMillis();
                    ((SendSyncMessageProcessor)SendSyncMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgFailed();
                    ((SendSyncMessageProcessor)SendSyncMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgCost(endTime - startTime);
                    SendSyncMessageProcessor.this.messageLogger.error("message|eventMesh2mq|REQ|SYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, sendMessageRequestBody.getTopic(), sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId(), context.getException()});
                }
            }, new RRCallback(){

                public void onSuccess(Message omsMsg) {
                    omsMsg.getUserProperties().put("BORN_TIMESTAMP", omsMsg.getSystemProperties("BORN_TIMESTAMP"));
                    omsMsg.getUserProperties().put("STORE_TIME", omsMsg.getSystemProperties("STORE_TIMESTAMP"));
                    omsMsg.getUserProperties().put("rsp_mq2eventMesh_timestamp", String.valueOf(System.currentTimeMillis()));
                    SendSyncMessageProcessor.this.messageLogger.info("message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, sendMessageRequestBody.getTopic(), sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId()});
                    try {
                        String rtnMsg = new String(omsMsg.getBody(), "UTF-8");
                        omsMsg.getUserProperties().put("rsp_eventMesh2c_timestamp", String.valueOf(System.currentTimeMillis()));
                        HttpCommand succ = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)JSON.toJSONString((Object)new SendMessageResponseBody.ReplyMessage(omsMsg.getSystemProperties("DESTINATION"), rtnMsg, OMSUtil.combineProp(omsMsg.getSystemProperties(), omsMsg.getUserProperties())))));
                        asyncContext.onComplete(succ, handler);
                    }
                    catch (Exception ex) {
                        HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
                        asyncContext.onComplete(err, handler);
                        SendSyncMessageProcessor.this.messageLogger.warn("message|mq2eventMesh|RSP", (Throwable)ex);
                    }
                }

                public void onException(Throwable e) {
                    HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_WAITING_RR_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err, handler);
                    SendSyncMessageProcessor.this.messageLogger.error("message|mq2eventMesh|RSP|SYNC|rrCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, sendMessageRequestBody.getTopic(), sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId(), e});
                }
            }, Integer.valueOf(ttl).intValue());
        }
        catch (Exception ex) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_SYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
            asyncContext.onComplete(err);
            long endTime = System.currentTimeMillis();
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgFailed();
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendMsgCost(endTime - startTime);
            this.messageLogger.error("message|eventMesh2mq|REQ|SYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, sendMessageRequestBody.getTopic(), sendMessageRequestBody.getBizSeqNo(), sendMessageRequestBody.getUniqueId(), ex});
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

