/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.ReplyMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.ReplyMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageResponseHeader;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyMessageProcessor
implements HttpRequestProcessor {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public ReplyMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtil.getLocalAddress()});
        ReplyMessageRequestHeader replyMessageRequestHeader = (ReplyMessageRequestHeader)asyncContext.getRequest().getHeader();
        final ReplyMessageRequestBody replyMessageRequestBody = (ReplyMessageRequestBody)asyncContext.getRequest().getBody();
        final ReplyMessageResponseHeader replyMessageResponseHeader = ReplyMessageResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtil.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)replyMessageRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)replyMessageRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)replyMessageRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)replyMessageRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)replyMessageRequestBody.getBizSeqNo()) || StringUtils.isBlank((CharSequence)replyMessageRequestBody.getUniqueId()) || StringUtils.isBlank((CharSequence)replyMessageRequestBody.getProducerGroup()) || StringUtils.isBlank((CharSequence)replyMessageRequestBody.getContent())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String producerGroup = replyMessageRequestBody.getProducerGroup();
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        final long startTime = System.currentTimeMillis();
        Message omsMsg = new Message();
        String replyTopic = "rr-reply-topic";
        HashMap extFields = replyMessageRequestBody.getExtFields();
        final String replyMQCluster = MapUtils.getString((Map)extFields, (Object)"CLUSTER", null);
        if (StringUtils.isEmpty((CharSequence)replyMQCluster)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        replyTopic = replyMQCluster + "-" + replyTopic;
        try {
            omsMsg.setBody(replyMessageRequestBody.getContent().getBytes("UTF-8"));
            omsMsg.setTopic(replyTopic);
            omsMsg.putSystemProperties("DESTINATION", replyTopic);
            omsMsg.putUserProperties("msgType", "persistent");
            for (Map.Entry entry : extFields.entrySet()) {
                omsMsg.putUserProperties((String)entry.getKey(), (String)entry.getValue());
            }
            omsMsg.putSystemProperties("TIMEOUT", String.valueOf(3000));
            omsMsg.putUserProperties("req_c2eventMesh_timestamp", String.valueOf(System.currentTimeMillis()));
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)replyMessageRequestBody.getBizSeqNo(), (Object)replyTopic);
            }
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{replyMessageRequestBody.getBizSeqNo(), replyTopic, e});
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        SendMessageContext sendMessageContext = new SendMessageContext(replyMessageRequestBody.getBizSeqNo(), omsMsg, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsg();
        final CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

            @Override
            public void onResponse(HttpCommand httpCommand) {
                try {
                    if (ReplyMessageProcessor.this.httpLogger.isDebugEnabled()) {
                        ReplyMessageProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                    }
                    ReplyMessageProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    ((ReplyMessageProcessor)ReplyMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        try {
            sendMessageContext.getMsg().getUserProperties().put("req_eventMesh2mq_timestamp", String.valueOf(System.currentTimeMillis()));
            eventMeshProducer.reply(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    HttpCommand succ = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
                    asyncContext.onComplete(succ, handler);
                    long endTime = System.currentTimeMillis();
                    ((ReplyMessageProcessor)ReplyMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.info("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", replyMessageRequestBody.getOrigTopic(), replyMessageRequestBody.getBizSeqNo(), replyMessageRequestBody.getUniqueId()});
                }

                public void onException(OnExceptionContext context) {
                    HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                    asyncContext.onComplete(err, handler);
                    long endTime = System.currentTimeMillis();
                    ((ReplyMessageProcessor)ReplyMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsgFailed();
                    ((ReplyMessageProcessor)ReplyMessageProcessor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", replyMessageRequestBody.getOrigTopic(), replyMessageRequestBody.getBizSeqNo(), replyMessageRequestBody.getUniqueId(), context.getException()});
                }
            });
        }
        catch (Exception ex) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
            asyncContext.onComplete(err);
            long endTime = System.currentTimeMillis();
            this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, replyMessageRequestBody.getOrigTopic(), replyMessageRequestBody.getBizSeqNo(), replyMessageRequestBody.getUniqueId(), ex});
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsgFailed();
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordReplyMsgCost(endTime - startTime);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

