/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2RequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2ResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2RequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2ResponseHeader;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageV2Processor
implements HttpRequestProcessor {
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    private EventMeshHTTPServer eventMeshHTTPServer;
    public Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");

    public BatchSendMessageV2Processor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        HttpCommand responseEventMeshCommand;
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtil.getLocalAddress()});
        SendMessageBatchV2RequestHeader sendMessageBatchV2RequestHeader = (SendMessageBatchV2RequestHeader)asyncContext.getRequest().getHeader();
        final SendMessageBatchV2RequestBody sendMessageBatchV2RequestBody = (SendMessageBatchV2RequestBody)asyncContext.getRequest().getBody();
        SendMessageBatchV2ResponseHeader sendMessageBatchV2ResponseHeader = SendMessageBatchV2ResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtil.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)sendMessageBatchV2RequestHeader.getPid()) || StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand2 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand2);
            return;
        }
        if (StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getBizSeqNo()) || StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getTopic()) || StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getProducerGroup()) || StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getMsg())) {
            HttpCommand responseEventMeshCommand3 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand3);
            return;
        }
        if (!this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerBatchMsgNumLimiter.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand4 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendBatchMsgDiscard(1L);
            asyncContext.onComplete(responseEventMeshCommand4);
            return;
        }
        String producerGroup = sendMessageBatchV2RequestBody.getProducerGroup();
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand5 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand5);
            return;
        }
        final long batchStartTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getTtl()) || !StringUtils.isNumeric((CharSequence)sendMessageBatchV2RequestBody.getTtl())) {
            sendMessageBatchV2RequestBody.setTtl(String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS));
        }
        Message omsMsg = new Message();
        try {
            omsMsg.setBody(sendMessageBatchV2RequestBody.getMsg().getBytes("UTF-8"));
            omsMsg.setTopic(sendMessageBatchV2RequestBody.getTopic());
            omsMsg.putSystemProperties("DESTINATION", sendMessageBatchV2RequestBody.getTopic());
            if (!StringUtils.isBlank((CharSequence)sendMessageBatchV2RequestBody.getTag())) {
                omsMsg.putUserProperties("TAG", sendMessageBatchV2RequestBody.getTag());
            }
            omsMsg.putUserProperties("msgType", "persistent");
            omsMsg.putSystemProperties("TIMEOUT", sendMessageBatchV2RequestBody.getTtl());
            if (this.batchMessageLogger.isDebugEnabled()) {
                this.batchMessageLogger.debug("msg2MQMsg suc, topic:{}, msg:{}", (Object)sendMessageBatchV2RequestBody.getTopic(), (Object)sendMessageBatchV2RequestBody.getMsg());
            }
        }
        catch (Exception e) {
            this.batchMessageLogger.error("msg2MQMsg err, topic:{}, msg:{}", new Object[]{sendMessageBatchV2RequestBody.getTopic(), sendMessageBatchV2RequestBody.getMsg(), e});
            HttpCommand responseEventMeshCommand6 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand6);
            return;
        }
        this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendBatchMsg(1L);
        final SendMessageContext sendMessageContext = new SendMessageContext(sendMessageBatchV2RequestBody.getBizSeqNo(), omsMsg, batchEventMeshProducer, this.eventMeshHTTPServer);
        try {
            batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    long batchEndTime = System.currentTimeMillis();
                    ((BatchSendMessageV2Processor)BatchSendMessageV2Processor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.debug("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{sendMessageBatchV2RequestBody.getBizSeqNo(), batchEndTime - batchStartTime, sendMessageBatchV2RequestBody.getTopic()});
                }

                public void onException(OnExceptionContext context) {
                    long batchEndTime = System.currentTimeMillis();
                    BatchSendMessageV2Processor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    ((BatchSendMessageV2Processor)BatchSendMessageV2Processor.this).eventMeshHTTPServer.metrics.summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{sendMessageBatchV2RequestBody.getBizSeqNo(), batchEndTime - batchStartTime, sendMessageBatchV2RequestBody.getTopic(), context.getException()});
                }
            });
        }
        catch (Exception e) {
            responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            long batchEndTime = System.currentTimeMillis();
            this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
            this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{sendMessageBatchV2RequestBody.getBizSeqNo(), batchEndTime - batchStartTime, sendMessageBatchV2RequestBody.getTopic(), e});
        }
        responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
        asyncContext.onComplete(responseEventMeshCommand);
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

