/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.IPUtil;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchResponseHeader;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageProcessor
implements HttpRequestProcessor {
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    private EventMeshHTTPServer eventMeshHTTPServer;
    public Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");

    public BatchSendMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtil.getLocalAddress()});
        SendMessageBatchRequestHeader sendMessageBatchRequestHeader = (SendMessageBatchRequestHeader)asyncContext.getRequest().getHeader();
        SendMessageBatchRequestBody sendMessageBatchRequestBody = (SendMessageBatchRequestBody)asyncContext.getRequest().getBody();
        SendMessageBatchResponseHeader sendMessageBatchResponseHeader = SendMessageBatchResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtil.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)sendMessageBatchRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)sendMessageBatchRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)sendMessageBatchRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)sendMessageBatchRequestBody.getContents()) || StringUtils.isBlank((CharSequence)sendMessageBatchRequestBody.getBatchId()) || StringUtils.isBlank((CharSequence)sendMessageBatchRequestBody.getProducerGroup()) || Integer.valueOf(sendMessageBatchRequestBody.getSize()) != CollectionUtils.size((Object)sendMessageBatchRequestBody.getContents())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (!this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerBatchMsgNumLimiter.tryAcquire(Integer.valueOf(sendMessageBatchRequestBody.getSize()).intValue(), 100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendBatchMsgDiscard(Integer.valueOf(sendMessageBatchRequestBody.getSize()).intValue());
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String producerGroup = sendMessageBatchRequestBody.getProducerGroup();
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        long batchStartTime = System.currentTimeMillis();
        ArrayList<Message> msgList = new ArrayList<Message>();
        ConcurrentHashMap<String, Object> topicBatchMessageMappings = new ConcurrentHashMap<String, Object>();
        for (SendMessageBatchRequestBody.BatchMessageEntity msg : sendMessageBatchRequestBody.getContents()) {
            if (StringUtils.isBlank((CharSequence)msg.topic) || StringUtils.isBlank((CharSequence)msg.msg)) continue;
            if (StringUtils.isBlank((CharSequence)msg.ttl) || !StringUtils.isNumeric((CharSequence)msg.ttl)) {
                msg.ttl = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
            }
            try {
                Message omsMsg = new Message();
                omsMsg.setTopic(msg.topic);
                omsMsg.setBody(msg.msg.getBytes("UTF-8"));
                if (!StringUtils.isBlank((CharSequence)msg.tag)) {
                    omsMsg.putUserProperties("TAG", msg.tag);
                }
                omsMsg.putUserProperties("msgType", "persistent");
                omsMsg.putSystemProperties("TIMEOUT", msg.ttl);
                msgList.add(omsMsg);
                if (topicBatchMessageMappings.containsKey(msg.topic)) {
                    ((List)topicBatchMessageMappings.get(msg.topic)).add(omsMsg);
                } else {
                    ArrayList tmp = new ArrayList();
                    tmp.add(omsMsg);
                    topicBatchMessageMappings.put(msg.topic, tmp);
                }
                if (!this.batchMessageLogger.isDebugEnabled()) continue;
                this.batchMessageLogger.debug("msg2MQMsg suc, msg:{}", (Object)msg.msg);
            }
            catch (Exception e) {
                this.batchMessageLogger.error("msg2MQMsg err, msg:{}", (Object)msg, (Object)e);
            }
        }
        if (CollectionUtils.isEmpty(msgList)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String sizeStr = sendMessageBatchRequestBody.getSize();
        long delta = StringUtils.isNumeric((CharSequence)sizeStr) ? (long)Integer.parseInt(sizeStr) : 0L;
        this.eventMeshHTTPServer.metrics.summaryMetrics.recordSendBatchMsg(delta);
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerBatchMsgBatchEnabled) {
            for (List batchMsgs : topicBatchMessageMappings.values()) {
                Message omsMsg = new Message();
                final SendMessageContext sendMessageContext = new SendMessageContext(sendMessageBatchRequestBody.getBatchId(), omsMsg, batchEventMeshProducer, this.eventMeshHTTPServer);
                sendMessageContext.setMessageList(batchMsgs);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        } else {
            for (Message msg : msgList) {
                final SendMessageContext sendMessageContext = new SendMessageContext(sendMessageBatchRequestBody.getBatchId(), msg, batchEventMeshProducer, this.eventMeshHTTPServer);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        }
        long batchEndTime = System.currentTimeMillis();
        this.eventMeshHTTPServer.metrics.summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
        this.batchMessageLogger.debug("batchMessage|eventMesh2mq|REQ|ASYNC|batchId={}|send2MQCost={}ms|msgNum={}|topics={}", new Object[]{sendMessageBatchRequestBody.getBatchId(), batchEndTime - batchStartTime, sendMessageBatchRequestBody.getSize(), topicBatchMessageMappings.keySet()});
        HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
        asyncContext.onComplete(responseEventMeshCommand);
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

