/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import io.openmessaging.api.Message;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.EventMeshConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleMsgContext {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private String msgRandomNo;
    private String consumerGroup;
    private EventMeshConsumer eventMeshConsumer;
    private String bizSeqNo;
    private String uniqueId;
    private String topic;
    private SubscriptionItem subscriptionItem;
    private Message msg;
    private int ttl;
    private long createTime = System.currentTimeMillis();
    private AbstractContext context;
    private ConsumerGroupConf consumerGroupConfig;
    private EventMeshHTTPServer eventMeshHTTPServer;
    private ConsumerGroupTopicConf consumeTopicConfig;
    private Map<String, String> props;

    public HandleMsgContext(String msgRandomNo, String consumerGroup, EventMeshConsumer eventMeshConsumer, String topic, Message msg, SubscriptionItem subscriptionItem, AbstractContext context, ConsumerGroupConf consumerGroupConfig, EventMeshHTTPServer eventMeshHTTPServer, String bizSeqNo, String uniqueId, ConsumerGroupTopicConf consumeTopicConfig) {
        this.msgRandomNo = msgRandomNo;
        this.consumerGroup = consumerGroup;
        this.eventMeshConsumer = eventMeshConsumer;
        this.topic = topic;
        this.msg = msg;
        this.subscriptionItem = subscriptionItem;
        this.context = context;
        this.consumerGroupConfig = consumerGroupConfig;
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.bizSeqNo = bizSeqNo;
        this.uniqueId = uniqueId;
        this.consumeTopicConfig = consumeTopicConfig;
        String ttlStr = msg.getUserProperties("TIMEOUT");
        this.ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Integer.parseInt(ttlStr) : 3000;
    }

    public void addProp(String key, String val) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, val);
    }

    public String getProp(String key) {
        return this.props.get(key);
    }

    public String getMsgRandomNo() {
        return this.msgRandomNo;
    }

    public void setMsgRandomNo(String msgRandomNo) {
        this.msgRandomNo = msgRandomNo;
    }

    public ConsumerGroupTopicConf getConsumeTopicConfig() {
        return this.consumeTopicConfig;
    }

    public void setConsumeTopicConfig(ConsumerGroupTopicConf consumeTopicConfig) {
        this.consumeTopicConfig = consumeTopicConfig;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public EventMeshConsumer getEventMeshConsumer() {
        return this.eventMeshConsumer;
    }

    public void setEventMeshConsumer(EventMeshConsumer eventMeshConsumer) {
        this.eventMeshConsumer = eventMeshConsumer;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Message getMsg() {
        return this.msg;
    }

    public void setMsg(Message msg) {
        this.msg = msg;
    }

    public SubscriptionItem getSubscriptionItem() {
        return this.subscriptionItem;
    }

    public void setSubscriptionItem(SubscriptionItem subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public AbstractContext getContext() {
        return this.context;
    }

    public void setContext(AbstractContext context) {
        this.context = context;
    }

    public ConsumerGroupConf getConsumerGroupConfig() {
        return this.consumerGroupConfig;
    }

    public void setConsumerGroupConfig(ConsumerGroupConf consumerGroupConfig) {
        this.consumerGroupConfig = consumerGroupConfig;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public void finish() {
        if (this.eventMeshConsumer != null && this.context != null && this.msg != null) {
            if (this.messageLogger.isDebugEnabled()) {
                // empty if block
            }
            this.eventMeshConsumer.updateOffset(this.topic, this.subscriptionItem.getMode(), Arrays.asList(this.msg), this.context);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("handleMsgContext={").append("consumerGroup=").append(this.consumerGroup).append(",topic=").append(this.topic).append(",subscriptionItem=").append(this.subscriptionItem).append(",consumeTopicConfig=").append(this.consumeTopicConfig).append(",bizSeqNo=").append(this.bizSeqNo).append(",uniqueId=").append(this.uniqueId).append(",ttl=").append(this.ttl).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }
}

