/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.plugin;

import io.openmessaging.api.Message;
import io.openmessaging.api.SendCallback;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.eventmesh.api.RRCallback;
import org.apache.eventmesh.api.producer.MeshMQProducer;
import org.apache.eventmesh.runtime.core.plugin.MQWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProducerWrapper
extends MQWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MeshMQProducer meshMQProducer;

    public synchronized void init(Properties keyValue) throws Exception {
        if (this.inited.get()) {
            return;
        }
        this.meshMQProducer = this.getSpiMeshMQProducer();
        if (this.meshMQProducer == null) {
            this.logger.error("can't load the meshMQProducer plugin, please check.");
            throw new RuntimeException("doesn't load the meshMQProducer plugin, please check.");
        }
        this.meshMQProducer.init(keyValue);
        this.inited.compareAndSet(false, true);
    }

    private MeshMQProducer getSpiMeshMQProducer() {
        ServiceLoader<MeshMQProducer> meshMQProducerServiceLoader = ServiceLoader.load(MeshMQProducer.class);
        if (meshMQProducerServiceLoader.iterator().hasNext()) {
            return meshMQProducerServiceLoader.iterator().next();
        }
        return null;
    }

    public synchronized void start() throws Exception {
        if (this.started.get()) {
            return;
        }
        this.meshMQProducer.start();
        this.started.compareAndSet(false, true);
    }

    public synchronized void shutdown() throws Exception {
        if (!this.inited.get()) {
            return;
        }
        if (!this.started.get()) {
            return;
        }
        this.meshMQProducer.shutdown();
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
    }

    public void send(Message message, SendCallback sendCallback) throws Exception {
        this.meshMQProducer.send(message, sendCallback);
    }

    public void request(Message message, SendCallback sendCallback, RRCallback rrCallback, long timeout) throws Exception {
        this.meshMQProducer.request(message, sendCallback, rrCallback, timeout);
    }

    public Message request(Message message, long timeout) throws Exception {
        return this.meshMQProducer.request(message, timeout);
    }

    public boolean reply(Message message, SendCallback sendCallback) throws Exception {
        return this.meshMQProducer.reply(message, sendCallback);
    }

    public MeshMQProducer getMeshMQProducer() {
        return this.meshMQProducer;
    }
}

