/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.plugin;

import io.openmessaging.api.AsyncMessageListener;
import io.openmessaging.api.Message;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.consumer.MeshMQPushConsumer;
import org.apache.eventmesh.runtime.core.plugin.MQWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQConsumerWrapper
extends MQWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MeshMQPushConsumer meshMQPushConsumer;

    public void subscribe(String topic, AsyncMessageListener listener) throws Exception {
        this.meshMQPushConsumer.subscribe(topic, listener);
    }

    public void unsubscribe(String topic) throws Exception {
        this.meshMQPushConsumer.unsubscribe(topic);
    }

    public synchronized void init(Properties keyValue) throws Exception {
        this.meshMQPushConsumer = this.getMeshMQPushConsumer();
        if (this.meshMQPushConsumer == null) {
            this.logger.error("can't load the meshMQPushConsumer plugin, please check.");
            throw new RuntimeException("doesn't load the meshMQPushConsumer plugin, please check.");
        }
        this.meshMQPushConsumer.init(keyValue);
        this.inited.compareAndSet(false, true);
    }

    private MeshMQPushConsumer getMeshMQPushConsumer() {
        ServiceLoader<MeshMQPushConsumer> meshMQPushConsumerServiceLoader = ServiceLoader.load(MeshMQPushConsumer.class);
        if (meshMQPushConsumerServiceLoader.iterator().hasNext()) {
            return meshMQPushConsumerServiceLoader.iterator().next();
        }
        return null;
    }

    public synchronized void start() throws Exception {
        this.meshMQPushConsumer.start();
        this.started.compareAndSet(false, true);
    }

    public synchronized void shutdown() throws Exception {
        this.meshMQPushConsumer.shutdown();
        this.inited.compareAndSet(false, true);
        this.started.compareAndSet(false, true);
    }

    public void updateOffset(List<Message> msgs, AbstractContext eventMeshConsumeConcurrentlyContext) {
        this.meshMQPushConsumer.updateOffset(msgs, eventMeshConsumeConcurrentlyContext);
    }
}

