/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWraper;

public class EventMeshTCPConfiguration
extends CommonConfiguration {
    public int eventMeshTcpServerPort = 10000;
    public int eventMeshTcpIdleAllSeconds = 60;
    public int eventMeshTcpIdleWriteSeconds = 60;
    public int eventMeshTcpIdleReadSeconds = 60;
    public Integer eventMeshTcpMsgReqnumPerSecond = 15000;
    public int eventMeshTcpClientMaxNum = 10000;
    public boolean eventMeshTcpServerEnabled = Boolean.FALSE;
    public int eventMeshTcpGlobalScheduler = 5;
    public int eventMeshTcpTaskHandleExecutorPoolSize = Runtime.getRuntime().availableProcessors();
    public int eventMeshTcpMsgDownStreamExecutorPoolSize = Runtime.getRuntime().availableProcessors() > 8 ? Runtime.getRuntime().availableProcessors() : 8;
    public int eventMeshTcpSessionExpiredInMills = 60000;
    public int eventMeshTcpSessionUpstreamBufferSize = 100;
    public int eventMeshTcpMsgRetryTimes = 3;
    public int eventMeshTcpMsgRetryDelayInMills = 500;
    public int eventMeshTcpMsgRetryQueueSize = 10000;
    public Integer eventMeshTcpRebalanceIntervalInMills = 30000;
    public int eventMeshServerAdminPort = 10106;
    public boolean eventMeshTcpSendBackEnabled = Boolean.TRUE;
    public int eventMeshTcpSendBackMaxTimes = 3;
    public int eventMeshTcpPushFailIsolateTimeInMills = 30000;
    private TrafficShapingConfig gtc = new TrafficShapingConfig(0L, 10000L, 1000L, 2000L);
    private TrafficShapingConfig ctc = new TrafficShapingConfig(0L, 2000L, 1000L, 10000L);

    public EventMeshTCPConfiguration(ConfigurationWraper configurationWraper) {
        super(configurationWraper);
    }

    public void init() {
        String eventMeshTcpPushFailIsolateTimeInMillsStr;
        String eventMeshTcpSendBackEnabledStr;
        String eventMeshServerAdminPortStr;
        String eventMeshTcpRebalanceIntervalStr;
        String eventMeshTcpMsgRetryQueueSizeStr;
        String eventMeshTcpMsgRetryDelayInMillsStr;
        String eventMeshTcpMsgRetryTimesStr;
        String eventMeshTcpSessionUpstreamBufferSizeStr;
        String eventMeshTcpSessionExpiredInMillsStr;
        String eventMeshTcpMsgDownStreamExecutorPoolSizeStr;
        String eventMeshTcpTaskHandleExecutorPoolSizeStr;
        String eventMeshTcpGlobalSchedulerStr;
        super.init();
        String eventMeshTcpServerPortStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_PORT);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpServerPortStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpServerPortStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_TCP_PORT));
        this.eventMeshTcpServerPort = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpServerPortStr));
        String eventMeshTcpIdleReadSecondsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpIdleReadSecondsStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpIdleReadSecondsStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS));
        this.eventMeshTcpIdleReadSeconds = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpIdleReadSecondsStr));
        String eventMeshTcpIdleWriteSecondsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpIdleWriteSecondsStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpIdleWriteSecondsStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS));
        this.eventMeshTcpIdleWriteSeconds = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpIdleWriteSecondsStr));
        String eventMeshTcpIdleAllSecondsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpIdleAllSecondsStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpIdleAllSecondsStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS));
        this.eventMeshTcpIdleAllSeconds = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpIdleAllSecondsStr));
        String eventMeshTcpMsgReqnumPerSecondStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpMsgReqnumPerSecondStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpMsgReqnumPerSecondStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS));
        this.eventMeshTcpMsgReqnumPerSecond = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpMsgReqnumPerSecondStr));
        String eventMeshTcpClientMaxNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM);
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)eventMeshTcpClientMaxNumStr) && StringUtils.isNumeric((CharSequence)eventMeshTcpClientMaxNumStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM));
        this.eventMeshTcpClientMaxNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpClientMaxNumStr));
        String eventMeshTcpServerEnabledStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_TCP_SERVER_ENABLED);
        if (StringUtils.isNotEmpty((CharSequence)eventMeshTcpServerEnabledStr)) {
            this.eventMeshTcpServerEnabled = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpServerEnabledStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpGlobalSchedulerStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpGlobalSchedulerStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER));
            this.eventMeshTcpGlobalScheduler = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpGlobalSchedulerStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpTaskHandleExecutorPoolSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpTaskHandleExecutorPoolSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE));
            this.eventMeshTcpTaskHandleExecutorPoolSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpTaskHandleExecutorPoolSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpMsgDownStreamExecutorPoolSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpMsgDownStreamExecutorPoolSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE));
            this.eventMeshTcpMsgDownStreamExecutorPoolSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpMsgDownStreamExecutorPoolSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpSessionExpiredInMillsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpSessionExpiredInMillsStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME));
            this.eventMeshTcpSessionExpiredInMills = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpSessionExpiredInMillsStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpSessionUpstreamBufferSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpSessionUpstreamBufferSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE));
            this.eventMeshTcpSessionUpstreamBufferSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpSessionUpstreamBufferSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpMsgRetryTimesStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_TIMES)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpMsgRetryTimesStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_TIMES));
            this.eventMeshTcpMsgRetryTimes = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpMsgRetryTimesStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpMsgRetryDelayInMillsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_DELAY)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpMsgRetryDelayInMillsStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_DELAY));
            this.eventMeshTcpMsgRetryDelayInMills = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpMsgRetryDelayInMillsStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpMsgRetryQueueSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpMsgRetryQueueSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE));
            this.eventMeshTcpMsgRetryQueueSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpMsgRetryQueueSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpRebalanceIntervalStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpRebalanceIntervalStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL));
            this.eventMeshTcpRebalanceIntervalInMills = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpRebalanceIntervalStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAdminPortStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshServerAdminPortStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT));
            this.eventMeshServerAdminPort = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerAdminPortStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpSendBackEnabledStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_TCP_SEND_BACK_ENABLED)))) {
            this.eventMeshTcpSendBackEnabled = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpSendBackEnabledStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpPushFailIsolateTimeInMillsStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)eventMeshTcpPushFailIsolateTimeInMillsStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME));
            this.eventMeshTcpPushFailIsolateTimeInMills = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshTcpPushFailIsolateTimeInMillsStr));
        }
    }

    public TrafficShapingConfig getGtc() {
        return this.gtc;
    }

    public TrafficShapingConfig getCtc() {
        return this.ctc;
    }

    public static class TrafficShapingConfig {
        long writeLimit = 0L;
        long readLimit = 1000L;
        long checkInterval = 1000L;
        long maxTime = 5000L;

        public TrafficShapingConfig(long writeLimit, long readLimit, long checkInterval, long maxTime) {
            this.writeLimit = writeLimit;
            this.readLimit = readLimit;
            this.checkInterval = checkInterval;
            this.maxTime = maxTime;
        }

        public TrafficShapingConfig() {
        }

        public long getWriteLimit() {
            return this.writeLimit;
        }

        public void setWriteLimit(long writeLimit) {
            this.writeLimit = writeLimit;
        }

        public long getReadLimit() {
            return this.readLimit;
        }

        public void setReadLimit(long readLimit) {
            this.readLimit = readLimit;
        }

        public long getCheckInterval() {
            return this.checkInterval;
        }

        public void setCheckInterval(long checkInterval) {
            this.checkInterval = checkInterval;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        public String toString() {
            return "TrafficShapingConfig{writeLimit=" + this.writeLimit + ", readLimit=" + this.readLimit + ", checkInterval=" + this.checkInterval + ", maxTime=" + this.maxTime + '}';
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_SERVER_TCP_PORT = "eventMesh.server.tcp.port";
        public static String KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS = "eventMesh.server.tcp.readerIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS = "eventMesh.server.tcp.writerIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS = "eventMesh.server.tcp.allIdleSeconds";
        public static String KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM = "eventMesh.server.tcp.clientMaxNum";
        public static String KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS = "eventMesh.server.tcp.msgReqnumPerSecond";
        public static String KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL = "eventMesh.server.tcp.RebalanceIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER = "eventMesh.server.global.scheduler";
        public static String KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE = "eventMesh.server.tcp.taskHandleExecutorPoolSize";
        public static String KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE = "eventMesh.server.tcp.msgDownStreamExecutorPoolSize";
        public static String KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME = "eventMesh.server.session.expiredInMills";
        public static String KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE = "eventMesh.server.session.upstreamBufferSize";
        public static String KEYS_EVENTMESH_SERVER_SESSION_DOWNSTREAM_UNACK_SIZE = "eventMesh.server.session.downstreamUnackSize";
        public static String KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_TIMES = "eventMesh.server.retry.pushRetryTimes";
        public static String KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_DELAY = "eventMesh.server.retry.pushRetryDelayInMills";
        public static String KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE = "eventMesh.server.retry.pushRetryQueueSize";
        public static String KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT = "eventMesh.server.admin.http.port";
        public static String KEYS_EVENTMESH_TCP_SERVER_ENABLED = "eventMesh.server.tcp.enabled";
        public static String KEYS_EVENTMESH_TCP_SEND_BACK_ENABLED = "eventMesh.server.tcp.sendBack.enabled";
        public static String KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME = "eventMesh.server.tcp.pushFailIsolateTimeInMills";
        public static String KEYS_EVENTMESH_TCP_DOWNSTREAM_MAP_SIZE = "eventMesh.server.tcp.downstreamMapSize";

        ConfKeys() {
        }
    }
}

