/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWraper;

public class EventMeshHTTPConfiguration
extends CommonConfiguration {
    public int httpServerPort = 10105;
    public RateLimiter eventMeshServerBatchMsgNumLimiter = RateLimiter.create((double)20000.0);
    public boolean eventMeshServerBatchMsgBatchEnabled = Boolean.TRUE;
    public int eventMeshServerBatchMsgThreadNum = 10;
    public int eventMeshServerSendMsgThreadNum = 8;
    public int eventMeshServerPushMsgThreadNum = 8;
    public int eventMeshServerReplyMsgThreadNum = 8;
    public int eventMeshServerClientManageThreadNum = 4;
    public int eventMeshServerRegistryThreadNum = 10;
    public int eventMeshServerAdminThreadNum = 2;
    public int eventMeshServerRetryThreadNum = 2;
    public int eventMeshServerPullRegistryIntervel = 30000;
    public int eventMeshServerAsyncAccumulationThreshold = 1000;
    public int eventMeshServerRetryBlockQSize = 10000;
    public int eventMeshServerBatchBlockQSize = 1000;
    public int eventMeshServerSendMsgBlockQSize = 1000;
    public int eventMeshServerPushMsgBlockQSize = 1000;
    public int eventMeshServerClientManageBlockQSize = 1000;
    public int eventMeshServerBusyCheckIntervel = 1000;
    public boolean eventMeshServerConsumerEnabled = false;
    public boolean eventMeshServerUseTls = false;

    public EventMeshHTTPConfiguration(ConfigurationWraper configurationWraper) {
        super(configurationWraper);
    }

    public void init() {
        super.init();
        if (this.configurationWraper != null) {
            String eventMeshServerUseTlsStr;
            String eventMeshServerRetryThreadNumStr;
            String eventMeshServerConsumerEnabledStr;
            String eventMeshServerBusyCheckIntervelStr;
            String eventMeshServerClientManageBlockQSizeStr;
            String eventMeshServerPushMsgBlockQSizeStr;
            String eventMeshServerSendMsgBlockQSizeStr;
            String eventMeshServerBatchBlockQSizeStr;
            String eventMeshServerRetryBlockQSizeStr;
            String eventMeshServerAdminThreadNumStr;
            String eventMeshServerPullRegistryIntervelStr;
            String eventMeshServerClientManageThreadNumStr;
            String eventMeshServerRegistryThreadNumStr;
            String eventMeshServerPushMsgThreadNumStr;
            String eventMeshServerReplyMsgThreadNumStr;
            String eventMeshServerSendMsgThreadNumStr;
            String eventMeshServerAsyncAccumulationThresholdStr;
            String eventMeshServerBatchMsgBatchEnableStr;
            String eventMeshServerBatchMsgNumLimiterStr;
            String httpServerPortStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_HTTP_PORT);
            Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)httpServerPortStr) && StringUtils.isNumeric((CharSequence)httpServerPortStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_HTTP_PORT));
            this.httpServerPort = Integer.valueOf(StringUtils.deleteWhitespace((String)httpServerPortStr));
            String eventMeshServerBatchMsgThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_THREAD_NUM);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshServerBatchMsgThreadNumStr) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgThreadNumStr)) {
                this.eventMeshServerBatchMsgThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerBatchMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchMsgNumLimiterStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_RATELIMITER))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgNumLimiterStr)) {
                this.eventMeshServerBatchMsgNumLimiter = RateLimiter.create((double)Double.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerBatchMsgNumLimiterStr)));
            }
            if (StringUtils.isNotBlank((CharSequence)(eventMeshServerBatchMsgBatchEnableStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED)))) {
                this.eventMeshServerBatchMsgBatchEnabled = Boolean.valueOf(eventMeshServerBatchMsgBatchEnableStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAsyncAccumulationThresholdStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD))) && StringUtils.isNumeric((CharSequence)eventMeshServerAsyncAccumulationThresholdStr)) {
                this.eventMeshServerAsyncAccumulationThreshold = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerAsyncAccumulationThresholdStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SENDMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgThreadNumStr)) {
                this.eventMeshServerSendMsgThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerReplyMsgThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_REPLYMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerReplyMsgThreadNumStr)) {
                this.eventMeshServerReplyMsgThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerReplyMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_PUSHMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgThreadNumStr)) {
                this.eventMeshServerPushMsgThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRegistryThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRegistryThreadNumStr)) {
                this.eventMeshServerRegistryThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerRegistryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageThreadNumStr)) {
                this.eventMeshServerClientManageThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerClientManageThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPullRegistryIntervelStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_PULL_REGISTRY_INTERVEL))) && StringUtils.isNumeric((CharSequence)eventMeshServerPullRegistryIntervelStr)) {
                this.eventMeshServerPullRegistryIntervel = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerPullRegistryIntervelStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAdminThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ADMIN_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerAdminThreadNumStr)) {
                this.eventMeshServerAdminThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerAdminThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryBlockQSizeStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryBlockQSizeStr)) {
                this.eventMeshServerRetryBlockQSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerRetryBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchBlockQSizeStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchBlockQSizeStr)) {
                this.eventMeshServerBatchBlockQSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerBatchBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgBlockQSizeStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgBlockQSizeStr)) {
                this.eventMeshServerSendMsgBlockQSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgBlockQSizeStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgBlockQSizeStr)) {
                this.eventMeshServerPushMsgBlockQSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageBlockQSizeStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageBlockQSizeStr)) {
                this.eventMeshServerClientManageBlockQSize = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerClientManageBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBusyCheckIntervelStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_BUSY_CHECK_INTERVEL))) && StringUtils.isNumeric((CharSequence)eventMeshServerBusyCheckIntervelStr)) {
                this.eventMeshServerBusyCheckIntervel = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerBusyCheckIntervelStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerConsumerEnabledStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_CONSUMER_ENABLED)))) {
                this.eventMeshServerConsumerEnabled = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerConsumerEnabledStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryThreadNumStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryThreadNumStr)) {
                this.eventMeshServerRetryThreadNum = Integer.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerRetryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerUseTlsStr = this.configurationWraper.getProp(ConfKeys.KEY_EVENTMESH_HTTPS_ENABLED)))) {
                this.eventMeshServerUseTls = Boolean.valueOf(StringUtils.deleteWhitespace((String)eventMeshServerUseTlsStr));
            }
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_SERVER_HTTP_PORT = "eventMesh.server.http.port";
        public static String KEYS_EVENTMESH_BATCHMSG_THREAD_NUM = "eventMesh.server.batchmsg.threads.num";
        public static String KEYS_EVENTMESH_BATCHMSG_RATELIMITER = "eventMesh.server.batchmsg.speed.ratelimiter";
        public static String KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED = "eventMesh.server.batchmsg.batch.enabled";
        public static String KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD = "eventMesh.server.async.accumulation.threshold";
        public static String KEY_EVENTMESH_BUSY_CHECK_INTERVEL = "eventMesh.server.busy.check.intervel";
        public static String KEYS_EVENTMESH_SENDMSG_THREAD_NUM = "eventMesh.server.sendmsg.threads.num";
        public static String KEYS_EVENTMESH_REPLYMSG_THREAD_NUM = "eventMesh.server.replymsg.threads.num";
        public static String KEYS_EVENTMESH_PUSHMSG_THREAD_NUM = "eventMesh.server.pushmsg.threads.num";
        public static String KEYS_EVENTMESH_REGISTRY_THREAD_NUM = "eventMesh.server.registry.threads.num";
        public static String KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM = "eventMesh.server.clientmanage.threads.num";
        public static String KEYS_EVENTMESH_ADMIN_THREAD_NUM = "eventMesh.server.admin.threads.num";
        public static String KEY_EVENTMESH_RETRY_THREAD_NUM = "eventMesh.server.retry.threads.num";
        public static String KEYS_EVENTMESH_PULL_REGISTRY_INTERVEL = "eventMesh.server.pull.registry.intervel";
        public static String KEY_EVENTMESH_RETRY_BLOCKQ_SIZE = "eventMesh.server.retry.blockQ.size";
        public static String KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE = "eventMesh.server.batchmsg.blockQ.size";
        public static String KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE = "eventMesh.server.sendmsg.blockQ.size";
        public static String KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE = "eventMesh.server.pushmsg.blockQ.size";
        public static String KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE = "eventMesh.server.clientM.blockQ.size";
        public static String KEY_EVENTMESH_CONSUMER_ENABLED = "eventMesh.server.consumer.enabled";
        public static String KEY_EVENTMESH_HTTPS_ENABLED = "eventMesh.server.useTls.enabled";

        ConfKeys() {
        }
    }
}

