/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextFactory {
    private static Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private static String protocol = "TLSv1.1";
    private static String fileName;
    private static String pass;

    public static SSLContext getSslContext() {
        SSLContext sslContext = null;
        try {
            protocol = System.getProperty("ssl.server.protocol", "TLSv1.1");
            fileName = System.getProperty("ssl.server.cer", "sChat2.jks");
            char[] filePass = null;
            pass = System.getProperty("ssl.server.pass", "sNetty");
            if (StringUtils.isNotBlank((CharSequence)pass)) {
                filePass = pass.toCharArray();
            }
            sslContext = SSLContext.getInstance(protocol);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(Files.newInputStream(Paths.get(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + fileName, new String[0]), StandardOpenOption.READ), filePass);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, filePass);
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            httpLogger.warn("sslContext init failed", (Throwable)e);
            sslContext = null;
        }
        return sslContext;
    }
}

