/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.tcp.codec.Codec;
import org.apache.eventmesh.runtime.admin.controller.ClientManageController;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpConnectionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpExceptionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpMessageDispatcher;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.retry.EventMeshTcpRetryer;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMonitor;
import org.apache.eventmesh.runtime.util.EventMeshThreadFactoryImpl;

public class EventMeshTCPServer
extends AbstractRemotingServer {
    private ClientSessionGroupMapping clientSessionGroupMapping;
    private EventMeshTcpRetryer eventMeshTcpRetryer;
    private EventMeshTcpMonitor eventMeshTcpMonitor;
    private ClientManageController clientManageController;
    private EventMeshServer eventMeshServer;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private ScheduledExecutorService scheduler;
    private ExecutorService taskHandleExecutorService;
    private ExecutorService broadcastMsgDownstreamExecutorService;
    private ScheduledFuture<?> tcpRegisterTask;
    private RateLimiter rateLimiter;

    public void setClientSessionGroupMapping(ClientSessionGroupMapping clientSessionGroupMapping) {
        this.clientSessionGroupMapping = clientSessionGroupMapping;
    }

    public ClientManageController getClientManageController() {
        return this.clientManageController;
    }

    public void setClientManageController(ClientManageController clientManageController) {
        this.clientManageController = clientManageController;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public ExecutorService getTaskHandleExecutorService() {
        return this.taskHandleExecutorService;
    }

    public ExecutorService getBroadcastMsgDownstreamExecutorService() {
        return this.broadcastMsgDownstreamExecutorService;
    }

    public void setTaskHandleExecutorService(ExecutorService taskHandleExecutorService) {
        this.taskHandleExecutorService = taskHandleExecutorService;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public EventMeshTCPServer(EventMeshServer eventMeshServer, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshServer = eventMeshServer;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    private void startServer() throws Exception {
        Runnable r = () -> {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.ioGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.SO_TIMEOUT, (Object)600000)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_LINGER, (Object)0)).childOption(ChannelOption.SO_SNDBUF, (Object)262140).childOption(ChannelOption.SO_RCVBUF, (Object)262140).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(2048, 4096, 65536))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer(){

                public void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new Codec.Encoder()}).addLast(new ChannelHandler[]{new Codec.Decoder()}).addLast("global-traffic-shaping", (ChannelHandler)EventMeshTCPServer.this.globalTrafficShapingHandler).addLast("channel-traffic-shaping", (ChannelHandler)EventMeshTCPServer.this.newCTSHandler()).addLast(new ChannelHandler[]{new EventMeshTcpConnectionHandler(EventMeshTCPServer.this)}).addLast((EventExecutorGroup)EventMeshTCPServer.this.workerGroup, new ChannelHandler[]{new IdleStateHandler(((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleReadSeconds, ((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleWriteSeconds, ((EventMeshTCPServer)EventMeshTCPServer.this).eventMeshTCPConfiguration.eventMeshTcpIdleAllSeconds), new EventMeshTcpMessageDispatcher(EventMeshTCPServer.this), new EventMeshTcpExceptionHandler(EventMeshTCPServer.this)});
                }
            });
            try {
                int port = this.eventMeshTCPConfiguration.eventMeshTcpServerPort;
                ChannelFuture f = bootstrap.bind(port).sync();
                this.logger.info("EventMeshTCPServer[port={}] started.....", (Object)port);
                f.channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.logger.error("EventMeshTCPServer RemotingServer Start Err!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception e1) {
                    this.logger.error("EventMeshTCPServer RemotingServer shutdown Err!", (Throwable)e);
                }
                return;
            }
        };
        Thread t = new Thread(r, "eventMesh-tcp-server");
        t.start();
    }

    public void init() throws Exception {
        this.logger.info("==================EventMeshTCPServer Initialing==================");
        this.initThreadPool();
        this.rateLimiter = RateLimiter.create((double)this.eventMeshTCPConfiguration.eventMeshTcpMsgReqnumPerSecond.intValue());
        this.globalTrafficShapingHandler = this.newGTSHandler();
        this.clientManageController = new ClientManageController(this);
        this.clientSessionGroupMapping = new ClientSessionGroupMapping(this);
        this.clientSessionGroupMapping.init();
        this.eventMeshTcpRetryer = new EventMeshTcpRetryer(this);
        this.eventMeshTcpRetryer.init();
        this.eventMeshTcpMonitor = new EventMeshTcpMonitor(this);
        this.eventMeshTcpMonitor.init();
        this.logger.info("--------------------------EventMeshTCPServer Inited");
    }

    @Override
    public void start() throws Exception {
        this.startServer();
        this.clientSessionGroupMapping.start();
        this.eventMeshTcpRetryer.start();
        this.eventMeshTcpMonitor.start();
        this.clientManageController.start();
        this.logger.info("--------------------------EventMeshTCPServer Started");
    }

    @Override
    public void shutdown() throws Exception {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.logger.info("shutdown bossGroup, no client is allowed to connect access server");
        }
        this.clientSessionGroupMapping.shutdown();
        try {
            Thread.sleep(40000L);
        }
        catch (InterruptedException e) {
            this.logger.error("interruptedException occurred while sleeping", (Throwable)e);
        }
        this.globalTrafficShapingHandler.release();
        if (this.ioGroup != null) {
            this.ioGroup.shutdownGracefully();
            this.logger.info("shutdown ioGroup");
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.logger.info("shutdown workerGroup");
        }
        this.eventMeshTcpRetryer.shutdown();
        this.eventMeshTcpMonitor.shutdown();
        this.shutdownThreadPool();
        this.logger.info("--------------------------EventMeshTCPServer Shutdown");
    }

    private void initThreadPool() throws Exception {
        super.init("eventMesh-tcp");
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpGlobalScheduler, (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-scheduler", true));
        this.taskHandleExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpTaskHandleExecutorPoolSize, (int)this.eventMeshTCPConfiguration.eventMeshTcpTaskHandleExecutorPoolSize, new LinkedBlockingQueue(10000), (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-task-handle", true));
        this.broadcastMsgDownstreamExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.eventMeshTcpMsgDownStreamExecutorPoolSize, (int)this.eventMeshTCPConfiguration.eventMeshTcpMsgDownStreamExecutorPoolSize, new LinkedBlockingQueue(10000), (ThreadFactory)new EventMeshThreadFactoryImpl("eventMesh-tcp-msg-downstream", true));
    }

    private void shutdownThreadPool() {
        this.scheduler.shutdown();
        this.taskHandleExecutorService.shutdown();
    }

    private GlobalTrafficShapingHandler newGTSHandler() {
        GlobalTrafficShapingHandler handler = new GlobalTrafficShapingHandler(this.scheduler, 0L, this.eventMeshTCPConfiguration.getGtc().getReadLimit()){

            protected long calculateSize(Object msg) {
                return 1L;
            }
        };
        handler.setMaxTimeWait(1000L);
        return handler;
    }

    private ChannelTrafficShapingHandler newCTSHandler() {
        ChannelTrafficShapingHandler handler = new ChannelTrafficShapingHandler(0L, this.eventMeshTCPConfiguration.getCtc().getReadLimit()){

            protected long calculateSize(Object msg) {
                return 1L;
            }
        };
        handler.setMaxTimeWait(3000L);
        return handler;
    }

    public ClientSessionGroupMapping getClientSessionGroupMapping() {
        return this.clientSessionGroupMapping;
    }

    public EventMeshTcpRetryer getEventMeshTcpRetryer() {
        return this.eventMeshTcpRetryer;
    }

    public EventMeshTcpMonitor getEventMeshTcpMonitor() {
        return this.eventMeshTcpMonitor;
    }

    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }
}

