/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public EventMeshHTTPServer eventMeshHTTPServer;
    private EventMeshTCPServer eventMeshTCPServer;
    private EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private ServiceState serviceState;

    public EventMeshServer(EventMeshHTTPConfiguration eventMeshHttpConfiguration, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    public void init() throws Exception {
        this.eventMeshHTTPServer = new EventMeshHTTPServer(this, this.eventMeshHttpConfiguration);
        this.eventMeshHTTPServer.init();
        this.eventMeshTCPServer = new EventMeshTCPServer(this, this.eventMeshTCPConfiguration);
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.init();
        }
        String eventstore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        this.logger.info("eventstore : {}", (Object)eventstore);
        this.serviceState = ServiceState.INITED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void start() throws Exception {
        this.eventMeshHTTPServer.start();
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.start();
        }
        this.serviceState = ServiceState.RUNNING;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPING;
        this.logger.info("server state:{}", (Object)this.serviceState);
        this.eventMeshHTTPServer.shutdown();
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.shutdown();
        }
        this.serviceState = ServiceState.STOPED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }
}

