/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.command.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.SSLContextFactory;
import org.apache.eventmesh.runtime.common.Pair;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbrstractHTTPServer
extends AbstractRemotingServer {
    public Logger httpServerLogger = LoggerFactory.getLogger(this.getClass());
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public HTTPMetricsServer metrics;
    public DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean useTLS;
    public ThreadPoolExecutor asyncContextCompleteHandler = ThreadPoolFactory.createThreadPoolExecutor((int)10, (int)10, (String)"eventMesh-http-asyncContext-");
    protected HashMap<Integer, Pair<HttpRequestProcessor, ThreadPoolExecutor>> processorTable = new HashMap(64);

    public AbrstractHTTPServer(int port, boolean useTLS) {
        this.port = port;
        this.useTLS = useTLS;
    }

    public Map<String, Object> parseHTTPHeader(HttpRequest fullReq) {
        HashMap<String, Object> headerParam = new HashMap<String, Object>();
        for (String key : fullReq.headers().names()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_TYPE.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.ACCEPT_ENCODING.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_LENGTH.toString(), (CharSequence)key)) continue;
            headerParam.put(key, fullReq.headers().get(key));
        }
        return headerParam;
    }

    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(HttpHeaderValues.TEXT_PLAIN + "; charset=" + "UTF-8"));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendResponse(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    AbrstractHTTPServer.this.httpLogger.warn("send response to [{}] fail, will close this channel", (Object)RemotingHelper.parseChannelRemoteAddr(f.channel()));
                    f.channel().close();
                    return;
                }
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        Runnable r = () -> {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpsServerInitializer(SSLContextFactory.getSslContext())).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
            try {
                this.httpServerLogger.info("HTTPServer[port={}] started......", (Object)this.port);
                ChannelFuture future = b.bind(this.port).sync();
                future.channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.httpServerLogger.error("HTTPServer start Err!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception e1) {
                    this.httpServerLogger.error("HTTPServer shutdown Err!", (Throwable)e);
                }
                return;
            }
        };
        Thread t = new Thread(r, "eventMesh-http-server");
        t.start();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void init(String threadPrefix) throws Exception {
        super.init(threadPrefix);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.started.compareAndSet(true, false);
    }

    public void registerProcessor(Integer requestCode, HttpRequestProcessor processor, ThreadPoolExecutor executor) {
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{requestCode}), (Object)"requestCode can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{processor}), (Object)"processor can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{executor}), (Object)"executor can't be null");
        Pair<HttpRequestProcessor, ThreadPoolExecutor> pair = new Pair<HttpRequestProcessor, ThreadPoolExecutor>(processor, executor);
        this.processorTable.put(requestCode, pair);
    }

    static {
        DiskAttribute.deleteOnExitTemporaryFile = false;
    }

    class HttpsServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private SSLContext sslContext;

        public HttpsServerInitializer(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.sslContext != null && AbrstractHTTPServer.this.useTLS) {
                SSLEngine sslEngine = this.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), new HttpConnectionHandler(), new HttpObjectAggregator(Integer.MAX_VALUE), new HTTPHandler()});
        }
    }

    class HttpConnectionHandler
    extends ChannelDuplexHandler {
        public AtomicInteger connections = new AtomicInteger(0);

        HttpConnectionHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            int c = this.connections.incrementAndGet();
            if (c > 20000) {
                AbrstractHTTPServer.this.httpServerLogger.warn("client|http|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"too many client(20000) connect this eventMesh server");
                ctx.close();
                return;
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connections.decrementAndGet();
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                AbrstractHTTPServer.this.httpServerLogger.info("client|http|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
                ctx.close();
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class HTTPHandler
    extends SimpleChannelInboundHandler<HttpRequest> {
        HTTPHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) throws Exception {
            HttpPostRequestDecoder decoder = null;
            try {
                if (!httpRequest.decoderResult().isSuccess()) {
                    AbrstractHTTPServer.this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                HttpCommand requestCommand = new HttpCommand();
                httpRequest.headers().set("Ip", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
                String protocolVersion = StringUtils.deleteWhitespace((String)httpRequest.headers().get("Version"));
                if (StringUtils.isBlank((CharSequence)protocolVersion)) {
                    protocolVersion = ProtocolVersion.V1.getVersion();
                    httpRequest.headers().set("Version", (Object)ProtocolVersion.V1.getVersion());
                }
                AbrstractHTTPServer.this.metrics.summaryMetrics.recordHTTPRequest();
                long bodyDecodeStart = System.currentTimeMillis();
                HashMap<String, String> bodyMap = new HashMap<String, String>();
                if (httpRequest.method() == HttpMethod.GET) {
                    QueryStringDecoder getDecoder = new QueryStringDecoder(httpRequest.uri());
                    getDecoder.parameters().entrySet().forEach(entry -> bodyMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0)));
                } else {
                    if (httpRequest.method() != HttpMethod.POST) {
                        AbrstractHTTPServer.this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                        return;
                    }
                    decoder = new HttpPostRequestDecoder((HttpDataFactory)AbrstractHTTPServer.this.defaultHttpDataFactory, httpRequest);
                    List parmList = decoder.getBodyHttpDatas();
                    for (InterfaceHttpData parm : parmList) {
                        if (parm.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                        Attribute data = (Attribute)parm;
                        bodyMap.put(data.getName(), data.getValue());
                    }
                }
                AbrstractHTTPServer.this.metrics.summaryMetrics.recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
                String requestCode = httpRequest.method() == HttpMethod.POST ? StringUtils.deleteWhitespace((String)httpRequest.headers().get("Code")) : MapUtils.getString(bodyMap, (Object)StringUtils.lowerCase((String)"Code"), (String)"");
                requestCommand.setHttpMethod(httpRequest.method().name());
                requestCommand.setHttpVersion(httpRequest.protocolVersion().protocolName());
                requestCommand.setRequestCode(requestCode);
                HttpCommand responseCommand = null;
                if (!ProtocolVersion.contains((String)protocolVersion)) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
                    AbrstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                    return;
                }
                if (StringUtils.isBlank((CharSequence)requestCode) || !StringUtils.isNumeric((CharSequence)requestCode) || !RequestCode.contains((Integer)Integer.valueOf(requestCode)) || !AbrstractHTTPServer.this.processorTable.containsKey(Integer.valueOf(requestCode))) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID.getRetCode(), EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID.getErrMsg());
                    AbrstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                    return;
                }
                if (!AbrstractHTTPServer.this.started.get()) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_STOP.getRetCode(), EventMeshRetCode.EVENTMESH_STOP.getErrMsg());
                    AbrstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                    return;
                }
                try {
                    requestCommand.setHeader(Header.buildHeader((String)requestCode, AbrstractHTTPServer.this.parseHTTPHeader(httpRequest)));
                    requestCommand.setBody(Body.buildBody((String)requestCode, bodyMap));
                }
                catch (Exception e) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getRetCode(), EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 3));
                    AbrstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                    try {
                        decoder.destroy();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (AbrstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                    AbrstractHTTPServer.this.httpLogger.debug("{}", (Object)requestCommand);
                }
                AsyncContext<HttpCommand> asyncContext = new AsyncContext<HttpCommand>(requestCommand, responseCommand, AbrstractHTTPServer.this.asyncContextCompleteHandler);
                this.processEventMeshRequest(ctx, asyncContext);
                return;
            }
            catch (Exception ex) {
                AbrstractHTTPServer.this.httpServerLogger.error("AbrstractHTTPServer.HTTPHandler.channelRead0 err", (Throwable)ex);
                return;
            }
            finally {
                try {
                    decoder.destroy();
                }
                catch (Exception exception) {}
            }
        }

        public void processEventMeshRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) {
            Pair<HttpRequestProcessor, ThreadPoolExecutor> choosed = AbrstractHTTPServer.this.processorTable.get(Integer.valueOf(asyncContext.getRequest().getRequestCode()));
            try {
                choosed.getObject2().submit(() -> {
                    try {
                        if (((HttpRequestProcessor)choosed.getObject1()).rejectRequest()) {
                            HttpCommand responseCommand = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR.getRetCode(), EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR.getErrMsg());
                            asyncContext.onComplete(responseCommand);
                            if (asyncContext.isComplete()) {
                                if (AbrstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                                    AbrstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                                }
                                AbrstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                            }
                            return;
                        }
                        ((HttpRequestProcessor)choosed.getObject1()).processRequest(ctx, asyncContext);
                        if (asyncContext == null || !asyncContext.isComplete()) {
                            return;
                        }
                        AbrstractHTTPServer.this.metrics.summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                        if (AbrstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                            AbrstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                        }
                        AbrstractHTTPServer.this.sendResponse(ctx, ((HttpCommand)asyncContext.getResponse()).httpResponse());
                    }
                    catch (Exception e) {
                        AbrstractHTTPServer.this.httpServerLogger.error("process error", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                HttpCommand responseCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.OVERLOAD.getRetCode(), EventMeshRetCode.OVERLOAD.getErrMsg());
                asyncContext.onComplete(responseCommand);
                AbrstractHTTPServer.this.metrics.summaryMetrics.recordHTTPDiscard();
                AbrstractHTTPServer.this.metrics.summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - responseCommand.getReqTime());
                try {
                    AbrstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (null != cause) {
                cause.printStackTrace();
            }
            if (null != ctx) {
                ctx.close();
            }
        }
    }
}

