/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowClientHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShowClientHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowClientHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            String newLine = System.getProperty("line.separator");
            logger.info("showAllClient=================");
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            HashMap<String, AtomicInteger> statMap = new HashMap<String, AtomicInteger>();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            if (!sessionMap.isEmpty()) {
                for (Session session : sessionMap.values()) {
                    String key = session.getClient().getSubsystem();
                    if (!statMap.containsKey(key)) {
                        statMap.put(key, new AtomicInteger(1));
                        continue;
                    }
                    ((AtomicInteger)statMap.get(key)).incrementAndGet();
                }
                for (Map.Entry entry : statMap.entrySet()) {
                    result = result + String.format("System=%s | ClientNum=%d", entry.getKey(), ((AtomicInteger)entry.getValue()).intValue()) + newLine;
                }
            }
            httpExchange.sendResponseHeaders(200, 0L);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            logger.error("ShowClientHandler fail...", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

