/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectClientByPathHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedirectClientByPathHandler.class);
    private EventMeshTCPServer eventMeshTCPServer;

    public RedirectClientByPathHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            String queryString = httpExchange.getRequestURI().getQuery();
            Map<String, String> queryStringInfo = NetUtils.formData2Dic(queryString);
            String path = queryStringInfo.get("path");
            String destEventMeshIp = queryStringInfo.get("desteventMeshIp");
            String destEventMeshPort = queryStringInfo.get("desteventMeshPort");
            if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)destEventMeshIp) || StringUtils.isBlank((CharSequence)destEventMeshPort) || !StringUtils.isNumeric((CharSequence)destEventMeshPort)) {
                httpExchange.sendResponseHeaders(200, 0L);
                result = "params illegal!";
                out.write(result.getBytes());
                return;
            }
            logger.info("redirectClientByPath in admin,path:{},destIp:{},destPort:{}====================", new Object[]{path, destEventMeshIp, destEventMeshPort});
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            String redirectResult = "";
            try {
                if (!sessionMap.isEmpty()) {
                    for (Session session : sessionMap.values()) {
                        if (!session.getClient().getPath().contains(path)) continue;
                        redirectResult = redirectResult + "|";
                        redirectResult = redirectResult + EventMeshTcp2Client.redirectClient2NewEventMesh(this.eventMeshTCPServer, destEventMeshIp, Integer.parseInt(destEventMeshPort), session, clientSessionGroupMapping);
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientManage|redirectClientByPath|fail|path={}|destEventMeshIp={}|destEventMeshPort={},errMsg={}", new Object[]{path, destEventMeshIp, destEventMeshPort, e});
                result = String.format("redirectClientByPath fail! sessionMap size {%d}, {path=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s}, errorMsg : %s", sessionMap.size(), path, destEventMeshIp, destEventMeshPort, redirectResult, e.getMessage());
                httpExchange.sendResponseHeaders(200, 0L);
                out.write(result.getBytes());
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        logger.warn("out close failed...", (Throwable)e2);
                    }
                }
                return;
            }
            result = String.format("redirectClientByPath success! sessionMap size {%d}, {path=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s} ", sessionMap.size(), path, destEventMeshIp, destEventMeshPort, redirectResult);
            httpExchange.sendResponseHeaders(200, 0L);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            logger.error("redirectClientByPath fail...", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

