/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigurationWraper;

public class CommonConfiguration {
    public String eventMeshEnv = "P";
    public String eventMeshIDC = "FT";
    public String eventMeshCluster = "LS";
    public String eventMeshName = "";
    public String sysID = "5477";
    public String namesrvAddr = "";
    public String clientUserName = "username";
    public String clientPass = "user@123";
    public Integer consumeThreadMin = 2;
    public Integer consumeThreadMax = 2;
    public Integer consumeQueueSize = 10000;
    public Integer pullBatchSize = 32;
    public Integer ackWindow = 1000;
    public Integer pubWindow = 100;
    public long consumeTimeout = 0L;
    public Integer pollNameServerInteval = 10000;
    public Integer heartbeatBrokerInterval = 30000;
    public Integer rebalanceInterval = 20000;
    public Integer eventMeshRegisterIntervalInMills = 10000;
    public Integer eventMeshFetchRegistryAddrInterval = 10000;
    public String eventMeshServerIp = null;
    protected ConfigurationWraper configurationWraper;

    public CommonConfiguration(ConfigurationWraper configurationWraper) {
        this.configurationWraper = configurationWraper;
    }

    public void init() {
        if (this.configurationWraper != null) {
            String eventMeshEnvStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ENV);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshEnvStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ENV));
            this.eventMeshEnv = StringUtils.deleteWhitespace((String)eventMeshEnvStr);
            String sysIdStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SYSID);
            Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)sysIdStr) && StringUtils.isNumeric((CharSequence)sysIdStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SYSID));
            this.sysID = StringUtils.deleteWhitespace((String)sysIdStr);
            String eventMeshClusterStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_CLUSTER);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshClusterStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_CLUSTER));
            this.eventMeshCluster = StringUtils.deleteWhitespace((String)eventMeshClusterStr);
            String eventMeshNameStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_NAME);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshNameStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_NAME));
            this.eventMeshName = StringUtils.deleteWhitespace((String)eventMeshNameStr);
            String eventMeshIDCStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_IDC);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshIDCStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_IDC));
            this.eventMeshIDC = StringUtils.deleteWhitespace((String)eventMeshIDCStr);
            this.eventMeshServerIp = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_HOST_IP);
            if (StringUtils.isBlank((CharSequence)this.eventMeshServerIp)) {
                this.eventMeshServerIp = CommonConfiguration.getLocalAddr();
            }
        }
    }

    public static String getLocalAddr() {
        String priority = System.getProperty("networkInterface.priority", "bond1<eth1<eth0");
        ArrayList<String> preferList = new ArrayList<String>();
        for (String eth : priority.split("<")) {
            preferList.add(eth);
        }
        NetworkInterface preferNetworkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
            while (enumeration1.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration1.nextElement();
                if (!preferList.contains(networkInterface.getName())) continue;
                if (preferNetworkInterface == null) {
                    preferNetworkInterface = networkInterface;
                    continue;
                }
                if (preferList.indexOf(networkInterface.getName()) <= preferList.indexOf(preferNetworkInterface.getName())) continue;
                preferNetworkInterface = networkInterface;
            }
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            if (preferNetworkInterface != null) {
                Enumeration<InetAddress> en = preferNetworkInterface.getInetAddresses();
                CommonConfiguration.getIpResult(ipv4Result, ipv6Result, en);
            } else {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                    CommonConfiguration.getIpResult(ipv4Result, ipv6Result, en);
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                    return ip;
                }
                return ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return CommonConfiguration.normalizeHostAddress(localHost);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    private static void getIpResult(ArrayList<String> ipv4Result, ArrayList<String> ipv6Result, Enumeration<InetAddress> en) {
        while (en.hasMoreElements()) {
            InetAddress address = en.nextElement();
            if (address.isLoopbackAddress()) continue;
            if (address instanceof Inet6Address) {
                ipv6Result.add(CommonConfiguration.normalizeHostAddress(address));
                continue;
            }
            ipv4Result.add(CommonConfiguration.normalizeHostAddress(address));
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_ENV = "eventMesh.server.env";
        public static String KEYS_EVENTMESH_IDC = "eventMesh.server.idc";
        public static String KEYS_EVENTMESH_SYSID = "eventMesh.sysid";
        public static String KEYS_EVENTMESH_SERVER_CLUSTER = "eventMesh.server.cluster";
        public static String KEYS_EVENTMESH_SERVER_NAME = "eventMesh.server.name";
        public static String KEYS_EVENTMESH_SERVER_HOST_IP = "eventMesh.server.hostIp";
        public static String KEYS_EVENTMESH_SERVER_REGISTER_INTERVAL = "eventMesh.server.registry.registerIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_FETCH_REGISTRY_ADDR_INTERVAL = "eventMesh.server.registry.fetchRegistryAddrIntervalInMills";

        ConfKeys() {
        }
    }
}

