/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.command;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.BaseResponseBody;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.header.BaseResponseHeader;
import org.apache.eventmesh.common.protocol.http.header.Header;

public class HttpCommand {
    private static AtomicLong requestId = new AtomicLong(0L);
    private long opaque;
    private String requestCode;
    public String httpMethod;
    public String httpVersion;
    public Header header;
    public Body body;
    public long reqTime;
    public long resTime;
    public CmdType cmdType = CmdType.REQ;

    public HttpCommand() {
        this.reqTime = System.currentTimeMillis();
        this.opaque = requestId.incrementAndGet();
    }

    public HttpCommand(String httpMethod, String httpVersion, String requestCode) {
        this.httpMethod = httpMethod;
        this.httpVersion = httpVersion;
        this.reqTime = System.currentTimeMillis();
        this.requestCode = requestCode;
        this.opaque = requestId.incrementAndGet();
    }

    public HttpCommand createHttpCommandResponse(Header header, Body body) {
        if (StringUtils.isBlank((CharSequence)this.requestCode)) {
            return null;
        }
        HttpCommand response = new HttpCommand(this.httpMethod, this.httpVersion, this.requestCode);
        response.setOpaque(this.opaque);
        response.setReqTime(this.reqTime);
        response.setHeader(header);
        response.setBody(body);
        response.setCmdType(CmdType.RES);
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public HttpCommand createHttpCommandResponse(Integer retCode, String retMsg) {
        if (StringUtils.isBlank((CharSequence)this.requestCode)) {
            return null;
        }
        HttpCommand response = new HttpCommand(this.httpMethod, this.httpVersion, this.requestCode);
        response.setOpaque(this.opaque);
        response.setReqTime(this.reqTime);
        BaseResponseHeader baseResponseHeader = new BaseResponseHeader();
        baseResponseHeader.setCode(this.requestCode);
        response.setHeader(baseResponseHeader);
        BaseResponseBody baseResponseBody = new BaseResponseBody();
        baseResponseBody.setRetCode(retCode);
        baseResponseBody.setRetMsg(retMsg);
        response.setBody(baseResponseBody);
        response.setCmdType(CmdType.RES);
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public long getResTime() {
        return this.resTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public void setOpaque(long opaque) {
        this.opaque = opaque;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append(",").append("opaque=").append(this.opaque).append(",");
        if (this.cmdType == CmdType.RES) {
            sb.append("cost=").append(this.resTime - this.reqTime).append(",");
        }
        sb.append("header=").append(this.header).append(",").append("body=").append(this.body).append("}");
        return sb.toString();
    }

    public String abstractDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append(",").append("opaque=").append(this.opaque).append(",");
        if (this.cmdType == CmdType.RES) {
            sb.append("cost=").append(this.resTime - this.reqTime).append(",");
        }
        sb.append("header=").append(this.header).append(",").append("bodySize=").append(this.body.toString().length()).append("}");
        return sb.toString();
    }

    public String simpleDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append("}");
        return sb.toString();
    }

    public DefaultFullHttpResponse httpResponse() throws Exception {
        if (this.cmdType == CmdType.REQ) {
            return null;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])JSON.toJSONString((Object)this.getBody()).getBytes("UTF-8")));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(HttpHeaderValues.TEXT_PLAIN + "; charset=" + "UTF-8"));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Map<String, Object> customHeader = this.getHeader().toMap();
        if (MapUtils.isNotEmpty(customHeader)) {
            HttpHeaders heads = response.headers();
            for (String key : customHeader.keySet()) {
                heads.add(key, customHeader.get(key) == null ? "" : customHeader.get(key));
            }
        }
        return response;
    }

    public static enum CmdType {
        REQ,
        RES;

    }
}

