/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;

public class LiteMessage {
    private String bizSeqNo;
    private String uniqueId;
    private String topic;
    private String content;
    private Map<String, String> prop;
    private long createTime = System.currentTimeMillis();

    public LiteMessage() {
    }

    public LiteMessage(String bizSeqno, String uniqueId, String topic, String content) {
        this.bizSeqNo = bizSeqno;
        this.uniqueId = uniqueId;
        this.topic = topic;
        this.content = content;
    }

    public Map<String, String> getProp() {
        return this.prop;
    }

    public LiteMessage setProp(Map<String, String> prop) {
        this.prop = prop;
        return this;
    }

    public LiteMessage addProp(String key, String val) {
        if (this.prop == null) {
            this.prop = new HashMap<String, String>();
        }
        this.prop.put(key, val);
        return this;
    }

    public String getPropKey(String key) {
        if (this.prop == null) {
            return null;
        }
        return this.prop.get(key);
    }

    public LiteMessage removeProp(String key) {
        if (this.prop == null) {
            return this;
        }
        this.prop.remove(key);
        return this;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public LiteMessage setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
        return this;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public LiteMessage setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public LiteMessage setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public LiteMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liteMessage={").append("bizSeqNo=").append(this.bizSeqNo).append(",").append("uniqueId=").append(this.uniqueId).append(",").append("topic=").append(this.topic).append(",").append("content=").append(this.content).append(",").append("prop=").append(this.prop).append(",").append("createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }
}

