/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import io.netty.channel.Channel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPUtil {
    public static String getLocalAddress() {
        String dockerHostIp = System.getenv("docker_host_ip");
        if (dockerHostIp != null && !"".equals(dockerHostIp)) {
            return dockerHostIp;
        }
        String priority = System.getProperty("networkInterface.priority", "eth0<eth1<bond1");
        ArrayList<String> preferList = new ArrayList<String>();
        for (String eth : priority.split("<")) {
            preferList.add(eth);
        }
        NetworkInterface preferNetworkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
            while (enumeration1.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration1.nextElement();
                if (!preferList.contains(networkInterface.getName())) continue;
                if (preferNetworkInterface == null) {
                    preferNetworkInterface = networkInterface;
                    continue;
                }
                if (preferList.indexOf(networkInterface.getName()) <= preferList.indexOf(preferNetworkInterface.getName())) continue;
                preferNetworkInterface = networkInterface;
            }
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            if (preferNetworkInterface != null) {
                Enumeration<InetAddress> en = preferNetworkInterface.getInetAddresses();
                IPUtil.getIpResult(ipv4Result, ipv6Result, en);
            } else {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                    IPUtil.getIpResult(ipv4Result, ipv6Result, en);
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168") || !IPUtil.isValidIPV4Address(ip)) continue;
                    return ip;
                }
                return ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return IPUtil.normalizeHostAddress(localHost);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isValidIPV4Address(String ip) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255;
        Pattern p = Pattern.compile(regex);
        if (ip == null) {
            return false;
        }
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    private static void getIpResult(ArrayList<String> ipv4Result, ArrayList<String> ipv6Result, Enumeration<InetAddress> en) {
        while (en.hasMoreElements()) {
            InetAddress address = en.nextElement();
            if (address.isLoopbackAddress()) continue;
            if (address instanceof Inet6Address) {
                ipv6Result.add(IPUtil.normalizeHostAddress(address));
                continue;
            }
            ipv4Result.add(IPUtil.normalizeHostAddress(address));
        }
    }

    private static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }
}

