/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.utils;

import io.openmessaging.api.OMSBuiltinKeys;
import io.openmessaging.api.SendResult;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;

public class OMSUtil {
    public static String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "%OpenMessaging%" + System.nanoTime();
    }

    public static Message msgConvert(io.openmessaging.api.Message omsMessage) {
        Message rmqMessage = new Message();
        if (omsMessage == null) {
            throw new OMSRuntimeException("'message' is null");
        }
        if (omsMessage.getTopic() != null) {
            rmqMessage.setTopic(omsMessage.getTopic());
        }
        if (omsMessage.getKey() != null) {
            rmqMessage.setKeys(omsMessage.getKey());
        }
        if (omsMessage.getTag() != null) {
            rmqMessage.setTags(omsMessage.getTag());
        }
        if (omsMessage.getStartDeliverTime() > 0L) {
            rmqMessage.putUserProperty("TIMER_DELIVER_MS", String.valueOf(omsMessage.getStartDeliverTime()));
        }
        if (omsMessage.getBody() != null) {
            rmqMessage.setBody(omsMessage.getBody());
        }
        if (omsMessage.getShardingKey() != null && !omsMessage.getShardingKey().isEmpty()) {
            rmqMessage.putUserProperty("__SHARDINGKEY", omsMessage.getShardingKey());
        }
        Properties systemProperties = omsMessage.getSystemProperties();
        Properties userProperties = omsMessage.getUserProperties();
        for (String key : userProperties.stringPropertyNames()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)userProperties.getProperty(key));
        }
        for (String key : systemProperties.stringPropertyNames()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)systemProperties.getProperty(key));
        }
        return rmqMessage;
    }

    public static io.openmessaging.api.Message msgConvert(MessageExt rmqMsg) {
        io.openmessaging.api.Message message = new io.openmessaging.api.Message();
        if (rmqMsg.getTopic() != null) {
            message.setTopic(rmqMsg.getTopic());
        }
        if (rmqMsg.getKeys() != null) {
            message.setKey(rmqMsg.getKeys());
        }
        if (rmqMsg.getTags() != null) {
            message.setTag(rmqMsg.getTags());
        }
        if (rmqMsg.getBody() != null) {
            message.setBody(rmqMsg.getBody());
        }
        if (rmqMsg.getUserProperty("TIMER_DELIVER_MS") != null) {
            long ms = Long.parseLong(rmqMsg.getUserProperty("TIMER_DELIVER_MS"));
            rmqMsg.getProperties().remove("TIMER_DELIVER_MS");
            message.setStartDeliverTime(ms);
        }
        Properties systemProperties = new Properties();
        Properties userProperties = new Properties();
        Set entries = rmqMsg.getProperties().entrySet();
        for (Map.Entry entry : entries) {
            if (OMSUtil.isOMSHeader((String)entry.getKey())) {
                systemProperties.put(entry.getKey(), entry.getValue());
                continue;
            }
            userProperties.put(entry.getKey(), entry.getValue());
        }
        systemProperties.put("MESSAGE_ID", rmqMsg.getMsgId());
        systemProperties.put("DESTINATION", rmqMsg.getTopic());
        systemProperties.put("BORN_HOST", String.valueOf(rmqMsg.getBornHost()));
        systemProperties.put("BORN_TIMESTAMP", (Object)rmqMsg.getBornTimestamp());
        systemProperties.put("STORE_HOST", String.valueOf(rmqMsg.getStoreHost()));
        systemProperties.put("STORE_TIMESTAMP", (Object)rmqMsg.getStoreTimestamp());
        userProperties.put("QUEUE_ID", (Object)rmqMsg.getQueueId());
        userProperties.put("QUEUE_OFFSET", (Object)rmqMsg.getQueueOffset());
        message.setSystemProperties(systemProperties);
        message.setUserProperties(userProperties);
        return message;
    }

    public static MessageExt msgConvertExt(io.openmessaging.api.Message omsMessage) {
        MessageExt rmqMessageExt = new MessageExt();
        try {
            if (omsMessage.getKey() != null) {
                rmqMessageExt.setKeys(omsMessage.getKey());
            }
            if (omsMessage.getTag() != null) {
                rmqMessageExt.setTags(omsMessage.getTag());
            }
            if (omsMessage.getStartDeliverTime() > 0L) {
                rmqMessageExt.putUserProperty("TIMER_DELIVER_MS", String.valueOf(omsMessage.getStartDeliverTime()));
            }
            if (omsMessage.getBody() != null) {
                rmqMessageExt.setBody(omsMessage.getBody());
            }
            if (omsMessage.getShardingKey() != null && !omsMessage.getShardingKey().isEmpty()) {
                rmqMessageExt.putUserProperty("__SHARDINGKEY", omsMessage.getShardingKey());
            }
            Properties systemProperties = omsMessage.getSystemProperties();
            Properties userProperties = omsMessage.getUserProperties();
            rmqMessageExt.setTopic(omsMessage.getTopic());
            int queueId = (Integer)userProperties.get("QUEUE_ID");
            long queueOffset = (Long)userProperties.get("QUEUE_OFFSET");
            rmqMessageExt.setQueueId(queueId);
            rmqMessageExt.setQueueOffset(queueOffset);
            for (String key : userProperties.stringPropertyNames()) {
                MessageAccessor.putProperty((Message)rmqMessageExt, (String)key, (String)userProperties.getProperty(key));
            }
            for (String key : systemProperties.stringPropertyNames()) {
                MessageAccessor.putProperty((Message)rmqMessageExt, (String)key, (String)systemProperties.getProperty(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rmqMessageExt;
    }

    public static boolean isOMSHeader(String value) {
        for (Field field : OMSBuiltinKeys.class.getDeclaredFields()) {
            try {
                if (!field.get(OMSBuiltinKeys.class).equals(value)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return false;
    }

    public static SendResult sendResultConvert(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        SendResult sendResult = new SendResult();
        sendResult.setTopic(rmqResult.getMessageQueue().getTopic());
        sendResult.setMessageId(rmqResult.getMsgId());
        return sendResult;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = new Iterator<T>(){

                @Override
                public synchronized boolean hasNext() {
                    return false;
                }

                @Override
                public synchronized T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public synchronized void remove() {
                }
            };

            @Override
            public synchronized boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @Override
            public synchronized T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public synchronized void remove() {
                this.iterator.remove();
            }
        };
    }
}

