/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.producer;

import io.openmessaging.api.Message;
import io.openmessaging.api.MessageBuilder;
import io.openmessaging.api.MessagingAccessPoint;
import io.openmessaging.api.OMS;
import io.openmessaging.api.SendCallback;
import io.openmessaging.api.SendResult;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.eventmesh.api.RRCallback;
import org.apache.eventmesh.api.producer.MeshMQProducer;
import org.apache.eventmesh.connector.rocketmq.common.EventMeshConstants;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfiguration;
import org.apache.eventmesh.connector.rocketmq.config.ConfigurationWraper;
import org.apache.eventmesh.connector.rocketmq.producer.ProducerImpl;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQProducerImpl
implements MeshMQProducer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProducerImpl producer;
    public final String DEFAULT_ACCESS_DRIVER = "org.apache.eventmesh.connector.rocketmq.MessagingAccessPointImpl";

    public synchronized void init(Properties keyValue) {
        ConfigurationWraper configurationWraper = new ConfigurationWraper(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + "rocketmq-client.properties", false);
        ClientConfiguration clientConfiguration = new ClientConfiguration(configurationWraper);
        clientConfiguration.init();
        String producerGroup = keyValue.getProperty("producerGroup");
        String omsNamesrv = clientConfiguration.namesrvAddr;
        Properties properties = new Properties();
        properties.put("driverImpl", "org.apache.eventmesh.connector.rocketmq.MessagingAccessPointImpl");
        properties.put("ACCESS_POINTS", omsNamesrv);
        properties.put("REGION", "namespace");
        properties.put("RMQ_PRODUCER_GROUP", producerGroup);
        properties.put("OPERATION_TIMEOUT", (Object)3000);
        properties.put("PRODUCER_ID", producerGroup);
        MessagingAccessPoint messagingAccessPoint = OMS.builder().build(properties);
        this.producer = (ProducerImpl)messagingAccessPoint.createProducer(properties);
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer.isClosed();
    }

    public void start() {
        this.producer.start();
    }

    public synchronized void shutdown() {
        this.producer.shutdown();
    }

    public void send(Message message, SendCallback sendCallback) throws Exception {
        this.producer.sendAsync(message, sendCallback);
    }

    public void request(Message message, SendCallback sendCallback, RRCallback rrCallback, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        throw new UnsupportedOperationException("not support request-reply mode when eventstore=rocketmq");
    }

    public Message request(Message message, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        throw new UnsupportedOperationException("not support request-reply mode when eventstore=rocketmq");
    }

    public boolean reply(Message message, SendCallback sendCallback) throws Exception {
        throw new UnsupportedOperationException("not support request-reply mode when eventstore=rocketmq");
    }

    public void checkTopicExist(String topic) throws Exception {
        this.producer.getRocketmqProducer().getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().getDefaultTopicRouteInfoFromNameServer(topic, 3000L);
    }

    public void setExtFields() {
        this.producer.setExtFields();
    }

    public SendResult send(Message message) {
        return this.producer.send(message);
    }

    public void sendOneway(Message message) {
        this.producer.sendOneway(message);
    }

    public void sendAsync(Message message, SendCallback sendCallback) {
        this.producer.sendAsync(message, sendCallback);
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.producer.setCallbackExecutor(callbackExecutor);
    }

    public void updateCredential(Properties credentialProperties) {
        this.producer.updateCredential(credentialProperties);
    }

    public <T> MessageBuilder<T> messageBuilder() {
        return null;
    }
}

