/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.producer;

import io.openmessaging.api.MessageBuilder;
import io.openmessaging.api.OnExceptionContext;
import io.openmessaging.api.Producer;
import io.openmessaging.api.SendResult;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.eventmesh.connector.rocketmq.producer.AbstractOMSProducer;
import org.apache.eventmesh.connector.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageClientIDSetter;

public class ProducerImpl
extends AbstractOMSProducer
implements Producer {
    public static final int eventMeshServerAsyncAccumulationThreshold = 1000;

    public ProducerImpl(Properties properties) {
        super(properties);
    }

    public Properties attributes() {
        return this.properties;
    }

    public void setExtFields() {
        super.getRocketmqProducer().setRetryTimesWhenSendFailed(0);
        super.getRocketmqProducer().setRetryTimesWhenSendAsyncFailed(0);
        super.getRocketmqProducer().setPollNameServerInterval(60000);
        super.getRocketmqProducer().getDefaultMQProducerImpl().getmQClientFactory().getNettyClientConfig().setClientAsyncSemaphoreValue(1000);
        super.getRocketmqProducer().setCompressMsgBodyOverHowmuch(10);
    }

    public SendResult send(io.openmessaging.api.Message message) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msgRMQ = OMSUtil.msgConvert(message);
        try {
            org.apache.rocketmq.client.producer.SendResult sendResultRMQ = this.rocketmqProducer.send(msgRMQ);
            message.setMsgID(sendResultRMQ.getMsgId());
            SendResult sendResult = new SendResult();
            sendResult.setTopic(sendResultRMQ.getMessageQueue().getTopic());
            sendResult.setMessageId(sendResultRMQ.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error(String.format("Send message Exception, %s", message), (Throwable)e);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), e);
        }
    }

    public void sendOneway(io.openmessaging.api.Message message) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msgRMQ = OMSUtil.msgConvert(message);
        try {
            this.rocketmqProducer.sendOneway(msgRMQ);
            message.setMsgID(MessageClientIDSetter.getUniqID((Message)msgRMQ));
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", message), (Throwable)e);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), e);
        }
    }

    public void sendAsync(io.openmessaging.api.Message message, io.openmessaging.api.SendCallback sendCallback) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msgRMQ = OMSUtil.msgConvert(message);
        try {
            this.rocketmqProducer.send(msgRMQ, this.sendCallbackConvert(message, sendCallback));
            message.setMsgID(MessageClientIDSetter.getUniqID((Message)msgRMQ));
        }
        catch (Exception e) {
            log.error(String.format("Send message async Exception, %s", message), (Throwable)e);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), e);
        }
    }

    private SendCallback sendCallbackConvert(final io.openmessaging.api.Message message, final io.openmessaging.api.SendCallback sendCallback) {
        SendCallback rmqSendCallback = new SendCallback(){

            public void onSuccess(org.apache.rocketmq.client.producer.SendResult sendResult) {
                sendCallback.onSuccess(OMSUtil.sendResultConvert(sendResult));
            }

            public void onException(Throwable e) {
                String topic = message.getTopic();
                String msgId = message.getMsgID();
                OMSRuntimeException onsEx = ProducerImpl.this.checkProducerException(topic, msgId, e);
                OnExceptionContext context = new OnExceptionContext();
                context.setTopic(topic);
                context.setMessageId(msgId);
                context.setException(onsEx);
                sendCallback.onException(context);
            }
        };
        return rmqSendCallback;
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
    }

    public void updateCredential(Properties credentialProperties) {
    }

    public <T> MessageBuilder<T> messageBuilder() {
        return null;
    }
}

