/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.consumer;

import io.openmessaging.api.AsyncGenericMessageListener;
import io.openmessaging.api.AsyncMessageListener;
import io.openmessaging.api.GenericMessageListener;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.MessagingAccessPoint;
import io.openmessaging.api.OMS;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.consumer.MeshMQPushConsumer;
import org.apache.eventmesh.connector.rocketmq.common.EventMeshConstants;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfiguration;
import org.apache.eventmesh.connector.rocketmq.config.ConfigurationWraper;
import org.apache.eventmesh.connector.rocketmq.consumer.PushConsumerImpl;
import org.apache.eventmesh.connector.rocketmq.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.eventmesh.connector.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import org.apache.rocketmq.client.impl.consumer.ConsumeMessageService;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQConsumerImpl
implements MeshMQPushConsumer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public final String DEFAULT_ACCESS_DRIVER = "org.apache.eventmesh.connector.rocketmq.MessagingAccessPointImpl";
    private PushConsumerImpl pushConsumer;

    public synchronized void init(Properties keyValue) throws Exception {
        ConfigurationWraper configurationWraper = new ConfigurationWraper(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + "rocketmq-client.properties", false);
        ClientConfiguration clientConfiguration = new ClientConfiguration(configurationWraper);
        clientConfiguration.init();
        boolean isBroadcast = Boolean.parseBoolean(keyValue.getProperty("isBroadcast"));
        String consumerGroup = keyValue.getProperty("consumerGroup");
        String instanceName = keyValue.getProperty("instanceName");
        if (isBroadcast) {
            consumerGroup = "broadcast-" + consumerGroup;
        }
        String omsNamesrv = clientConfiguration.namesrvAddr;
        Properties properties = new Properties();
        properties.put("driverImpl", "org.apache.eventmesh.connector.rocketmq.MessagingAccessPointImpl");
        properties.put("ACCESS_POINTS", omsNamesrv);
        properties.put("REGION", "namespace");
        properties.put("instanceName", instanceName);
        properties.put("CONSUMER_ID", consumerGroup);
        if (isBroadcast) {
            properties.put("MESSAGE_MODEL", MessageModel.BROADCASTING.name());
        } else {
            properties.put("MESSAGE_MODEL", MessageModel.CLUSTERING.name());
        }
        MessagingAccessPoint messagingAccessPoint = OMS.builder().build(properties);
        this.pushConsumer = (PushConsumerImpl)messagingAccessPoint.createConsumer(properties);
    }

    public void subscribe(String topic, AsyncMessageListener listener) throws Exception {
        this.pushConsumer.subscribe(topic, "*", listener);
    }

    public boolean isStarted() {
        return this.pushConsumer.isStarted();
    }

    public boolean isClosed() {
        return this.pushConsumer.isClosed();
    }

    public synchronized void start() {
        this.pushConsumer.start();
    }

    public void updateOffset(List<Message> msgs, AbstractContext context) {
        ConsumeMessageService consumeMessageService = this.pushConsumer.getRocketmqPushConsumer().getDefaultMQPushConsumerImpl().getConsumeMessageService();
        ArrayList<MessageExt> msgExtList = new ArrayList<MessageExt>(msgs.size());
        for (Message msg : msgs) {
            msgExtList.add(OMSUtil.msgConvertExt(msg));
        }
        ((ConsumeMessageConcurrentlyService)consumeMessageService).updateOffset(msgExtList, (EventMeshConsumeConcurrentlyContext)context);
    }

    public void unsubscribe(String topic) {
        this.pushConsumer.unsubscribe(topic);
    }

    public synchronized void shutdown() {
        this.pushConsumer.shutdown();
    }

    public Properties attributes() {
        return this.pushConsumer.attributes();
    }

    public void subscribe(String topic, String subExpression, MessageListener listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public <T> void subscribe(String topic, String subExpression, GenericMessageListener<T> listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public <T> void subscribe(String topic, MessageSelector selector, GenericMessageListener<T> listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public void subscribe(String topic, String subExpression, AsyncMessageListener listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public void subscribe(String topic, MessageSelector selector, AsyncMessageListener listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public <T> void subscribe(String topic, String subExpression, AsyncGenericMessageListener<T> listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public <T> void subscribe(String topic, MessageSelector selector, AsyncGenericMessageListener<T> listener) {
        throw new UnsupportedOperationException("not supported yet");
    }

    public void updateCredential(Properties credentialProperties) {
    }
}

