/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.consumer;

import io.openmessaging.api.AsyncConsumeContext;
import io.openmessaging.api.AsyncGenericMessageListener;
import io.openmessaging.api.AsyncMessageListener;
import io.openmessaging.api.Consumer;
import io.openmessaging.api.GenericMessageListener;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfig;
import org.apache.eventmesh.connector.rocketmq.patch.EventMeshConsumeConcurrentlyContext;
import org.apache.eventmesh.connector.rocketmq.patch.EventMeshConsumeConcurrentlyStatus;
import org.apache.eventmesh.connector.rocketmq.patch.EventMeshMessageListenerConcurrently;
import org.apache.eventmesh.connector.rocketmq.utils.BeanUtils;
import org.apache.eventmesh.connector.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.LanguageCode;

public class PushConsumerImpl
implements Consumer {
    private final DefaultMQPushConsumer rocketmqPushConsumer;
    private final Properties properties;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, AsyncMessageListener> subscribeTable = new ConcurrentHashMap<String, AsyncMessageListener>();
    private final ClientConfig clientConfig;

    public PushConsumerImpl(Properties properties) {
        this.rocketmqPushConsumer = new DefaultMQPushConsumer();
        this.properties = properties;
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        String accessPoints = this.clientConfig.getAccessPoints();
        if (accessPoints == null || accessPoints.isEmpty()) {
            throw new OMSRuntimeException(-1, "OMS AccessPoints is null or empty.");
        }
        this.rocketmqPushConsumer.setNamesrvAddr(accessPoints.replace(',', ';'));
        String consumerGroup = this.clientConfig.getConsumerId();
        if (null == consumerGroup || consumerGroup.isEmpty()) {
            throw new OMSRuntimeException(-1, "Consumer Group is necessary for RocketMQ, please set it.");
        }
        this.rocketmqPushConsumer.setConsumerGroup(consumerGroup);
        this.rocketmqPushConsumer.setMaxReconsumeTimes(this.clientConfig.getRmqMaxRedeliveryTimes());
        this.rocketmqPushConsumer.setConsumeTimeout((long)this.clientConfig.getRmqMessageConsumeTimeout());
        this.rocketmqPushConsumer.setConsumeThreadMax(this.clientConfig.getRmqMaxConsumeThreadNums());
        this.rocketmqPushConsumer.setConsumeThreadMin(this.clientConfig.getRmqMinConsumeThreadNums());
        this.rocketmqPushConsumer.setMessageModel(MessageModel.valueOf((String)this.clientConfig.getMessageModel()));
        String consumerId = OMSUtil.buildInstanceName();
        this.rocketmqPushConsumer.setInstanceName(properties.getProperty("instanceName"));
        properties.put("CONSUMER_ID", consumerId);
        this.rocketmqPushConsumer.setLanguage(LanguageCode.OMS);
        if (this.clientConfig.getMessageModel().equalsIgnoreCase(MessageModel.BROADCASTING.name())) {
            this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new EventMeshMessageListenerConcurrently(){

                @Override
                public EventMeshConsumeConcurrentlyStatus handleMessage(MessageExt msg, EventMeshConsumeConcurrentlyContext context) {
                    if (msg == null) {
                        return EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                    msg.putUserProperty("BORN_TIMESTAMP", String.valueOf(msg.getBornTimestamp()));
                    msg.putUserProperty("STORE_TIMESTAMP", String.valueOf(msg.getStoreTimestamp()));
                    Message omsMsg = OMSUtil.msgConvert(msg);
                    AsyncMessageListener listener = (AsyncMessageListener)PushConsumerImpl.this.subscribeTable.get(msg.getTopic());
                    if (listener == null) {
                        throw new OMSRuntimeException(-1, String.format("The topic/queue %s isn't attached to this consumer", msg.getTopic()));
                    }
                    final Properties contextProperties = new Properties();
                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                    EventMeshAsyncConsumeContext omsContext = new EventMeshAsyncConsumeContext(){

                        public void commit(EventMeshAction action) {
                            switch (action) {
                                case CommitMessage: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                                    break;
                                }
                                case ReconsumeLater: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                                    break;
                                }
                                case ManualAck: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_FINISH.name());
                                    break;
                                }
                            }
                        }
                    };
                    omsContext.setAbstractContext((AbstractContext)context);
                    listener.consume(omsMsg, (AsyncConsumeContext)omsContext);
                    return EventMeshConsumeConcurrentlyStatus.valueOf(contextProperties.getProperty("rmq.message.consume.status"));
                }
            });
        } else {
            this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new EventMeshMessageListenerConcurrently(){

                @Override
                public EventMeshConsumeConcurrentlyStatus handleMessage(MessageExt msg, EventMeshConsumeConcurrentlyContext context) {
                    if (msg == null) {
                        return EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                    msg.putUserProperty("BORN_TIMESTAMP", String.valueOf(msg.getBornTimestamp()));
                    msg.putUserProperty("STORE_TIME", String.valueOf(msg.getStoreTimestamp()));
                    Message omsMsg = OMSUtil.msgConvert(msg);
                    AsyncMessageListener listener = (AsyncMessageListener)PushConsumerImpl.this.subscribeTable.get(msg.getTopic());
                    if (listener == null) {
                        throw new OMSRuntimeException(-1, String.format("The topic/queue %s isn't attached to this consumer", msg.getTopic()));
                    }
                    final Properties contextProperties = new Properties();
                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                    EventMeshAsyncConsumeContext omsContext = new EventMeshAsyncConsumeContext(){

                        public void commit(EventMeshAction action) {
                            switch (action) {
                                case CommitMessage: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                                    break;
                                }
                                case ReconsumeLater: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.RECONSUME_LATER.name());
                                    break;
                                }
                                case ManualAck: {
                                    contextProperties.put("rmq.message.consume.status", EventMeshConsumeConcurrentlyStatus.CONSUME_FINISH.name());
                                    break;
                                }
                            }
                        }
                    };
                    omsContext.setAbstractContext((AbstractContext)context);
                    listener.consume(omsMsg, (AsyncConsumeContext)omsContext);
                    return EventMeshConsumeConcurrentlyStatus.valueOf(contextProperties.getProperty("rmq.message.consume.status"));
                }
            });
        }
    }

    public Properties attributes() {
        return this.properties;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.rocketmqPushConsumer.start();
            }
            catch (Exception e) {
                throw new OMSRuntimeException(e.getMessage());
            }
        }
    }

    public synchronized void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.rocketmqPushConsumer.shutdown();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public DefaultMQPushConsumer getRocketmqPushConsumer() {
        return this.rocketmqPushConsumer;
    }

    public void subscribe(String topic, String subExpression, MessageListener listener) {
    }

    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
    }

    public <T> void subscribe(String topic, String subExpression, GenericMessageListener<T> listener) {
    }

    public <T> void subscribe(String topic, MessageSelector selector, GenericMessageListener<T> listener) {
    }

    public void subscribe(String topic, String subExpression, AsyncMessageListener listener) {
        this.subscribeTable.put(topic, listener);
        try {
            this.rocketmqPushConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new OMSRuntimeException(-1, String.format("RocketMQ push consumer can't attach to %s.", topic));
        }
    }

    public void subscribe(String topic, MessageSelector selector, AsyncMessageListener listener) {
    }

    public <T> void subscribe(String topic, String subExpression, AsyncGenericMessageListener<T> listener) {
    }

    public <T> void subscribe(String topic, MessageSelector selector, AsyncGenericMessageListener<T> listener) {
    }

    public void unsubscribe(String topic) {
        this.subscribeTable.remove(topic);
        try {
            this.rocketmqPushConsumer.unsubscribe(topic);
        }
        catch (Exception e) {
            throw new OMSRuntimeException(-1, String.format("RocketMQ push consumer fails to unsubscribe topic: %s", topic));
        }
    }

    public void updateCredential(Properties credentialProperties) {
    }
}

