/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWraper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private String file;
    private Properties properties = new Properties();
    private boolean reload = true;
    private ScheduledExecutorService configLoader = ThreadPoolFactory.createSingleScheduledExecutor((String)"eventMesh-configloader-");

    public ConfigurationWraper(String file, boolean reload) {
        this.file = file;
        this.reload = reload;
        this.init();
    }

    private void init() {
        this.load();
        if (this.reload) {
            this.configLoader.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ConfigurationWraper.this.load();
                }
            }, 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
    }

    private void load() {
        try {
            this.logger.info("loading config: {}", (Object)this.file);
            this.properties.load(new BufferedReader(new FileReader(new File(this.file))));
        }
        catch (IOException e) {
            this.logger.error("loading properties [{}] error", (Object)this.file, (Object)e);
        }
    }

    public String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : this.properties.getProperty(key, null);
    }
}

