/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.config;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.rocketmq.config.ConfigurationWraper;

public class ClientConfiguration {
    public String namesrvAddr = "";
    public String clientUserName = "username";
    public String clientPass = "password";
    public Integer consumeThreadMin = 2;
    public Integer consumeThreadMax = 2;
    public Integer consumeQueueSize = 10000;
    public Integer pullBatchSize = 32;
    public Integer ackWindow = 1000;
    public Integer pubWindow = 100;
    public long consumeTimeout = 0L;
    public Integer pollNameServerInteval = 10000;
    public Integer heartbeatBrokerInterval = 30000;
    public Integer rebalanceInterval = 20000;
    protected ConfigurationWraper configurationWraper;

    public ClientConfiguration(ConfigurationWraper configurationWraper) {
        this.configurationWraper = configurationWraper;
    }

    public void init() {
        String clientRebalanceIntervalIntervalStr;
        String clientHeartbeatBrokerIntervalStr;
        String clientPollNamesrvIntervalStr;
        String clientPullBatchSizeStr;
        String consumeTimeoutStr;
        String clientPubWindowStr;
        String clientAckWindowStr;
        String consumerThreadPoolQueueSizeStr;
        String consumeThreadPoolMaxStr;
        String clientPassStr;
        String clientUserNameStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_USERNAME);
        if (StringUtils.isNotBlank((CharSequence)clientUserNameStr)) {
            this.clientUserName = StringUtils.trim((String)clientUserNameStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(clientPassStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_PASSWORD)))) {
            this.clientPass = StringUtils.trim((String)clientPassStr);
        }
        String namesrvAddrStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_NAMESRV_ADDR);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)namesrvAddrStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_NAMESRV_ADDR));
        this.namesrvAddr = StringUtils.trim((String)namesrvAddrStr);
        String consumeThreadPoolMinStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MIN);
        if (StringUtils.isNotEmpty((CharSequence)consumeThreadPoolMinStr)) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)consumeThreadPoolMinStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MIN));
            this.consumeThreadMin = Integer.valueOf(consumeThreadPoolMinStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(consumeThreadPoolMaxStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MAX)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)consumeThreadPoolMaxStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MAX));
            this.consumeThreadMax = Integer.valueOf(consumeThreadPoolMaxStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(consumerThreadPoolQueueSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_QUEUESIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)consumerThreadPoolQueueSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_QUEUESIZE));
            this.consumeQueueSize = Integer.valueOf(consumerThreadPoolQueueSizeStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientAckWindowStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_ACK_WINDOW)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientAckWindowStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_ACK_WINDOW));
            this.ackWindow = Integer.valueOf(clientAckWindowStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientPubWindowStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_PUB_WINDOW)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientPubWindowStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_PUB_WINDOW));
            this.pubWindow = Integer.valueOf(clientPubWindowStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(consumeTimeoutStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_CONSUME_TIMEOUT)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)consumeTimeoutStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_CONSUME_TIMEOUT));
            this.consumeTimeout = Long.valueOf(consumeTimeoutStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientPullBatchSizeStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_PULL_BATCHSIZE)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientPullBatchSizeStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_PULL_BATCHSIZE));
            this.pullBatchSize = Integer.valueOf(clientPullBatchSizeStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientPollNamesrvIntervalStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_POLL_NAMESRV_INTERVAL)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientPollNamesrvIntervalStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_POLL_NAMESRV_INTERVAL));
            this.pollNameServerInteval = Integer.valueOf(clientPollNamesrvIntervalStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientHeartbeatBrokerIntervalStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_HEARTBEAT_BROKER_INTERVEL)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientHeartbeatBrokerIntervalStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_HEARTBEAT_BROKER_INTERVEL));
            this.heartbeatBrokerInterval = Integer.valueOf(clientHeartbeatBrokerIntervalStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clientRebalanceIntervalIntervalStr = this.configurationWraper.getProp(ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_REBALANCE_INTERVEL)))) {
            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)clientRebalanceIntervalIntervalStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_ROCKETMQ_CLIENT_REBALANCE_INTERVEL));
            this.rebalanceInterval = Integer.valueOf(clientRebalanceIntervalIntervalStr);
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_ROCKETMQ_NAMESRV_ADDR = "eventMesh.server.rocketmq.namesrvAddr";
        public static String KEYS_EVENTMESH_ROCKETMQ_USERNAME = "eventMesh.server.rocketmq.username";
        public static String KEYS_EVENTMESH_ROCKETMQ_PASSWORD = "eventMesh.server.rocketmq.password";
        public static String KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MIN = "eventMesh.server.rocketmq.client.consumeThreadMin";
        public static String KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_MAX = "eventMesh.server.rocketmq.client.consumeThreadMax";
        public static String KEYS_EVENTMESH_ROCKETMQ_CONSUME_THREADPOOL_QUEUESIZE = "eventMesh.server.rocketmq.client.consumeThreadPoolQueueSize";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_ACK_WINDOW = "eventMesh.server.rocketmq.client.ackwindow";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_PUB_WINDOW = "eventMesh.server.rocketmq.client.pubwindow";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_CONSUME_TIMEOUT = "eventMesh.server.rocketmq.client.comsumeTimeoutInMin";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_PULL_BATCHSIZE = "eventMesh.server.rocketmq.client.pullBatchSize";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_POLL_NAMESRV_INTERVAL = "eventMesh.server.rocketmq.client.pollNameServerInterval";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_HEARTBEAT_BROKER_INTERVEL = "eventMesh.server.rocketmq.client.heartbeatBrokerInterval";
        public static String KEYS_EVENTMESH_ROCKETMQ_CLIENT_REBALANCE_INTERVEL = "eventMesh.server.rocketmq.client.rebalanceInterval";

        ConfKeys() {
        }
    }
}

