/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

import styled from 'styled-components';
import { Colors } from '@blueprintjs/core';

export const Wrapper = styled.div`
  display: flex;
  flex-direction: column;
  align-items: center;
  padding-top: 100px;
  height: 100vh;
  background-color: #f9f9fa;
  box-sizing: border-box;
`;

export const Inner = styled.div`
  margin: 32px auto 0;
  width: 820px;

  h2 {
    display: flex;
    align-items: center;
    margin: 0;

    .bp4-icon {
      margin-right: 4px;
    }
  }

  p {
    margin: 16px 0;

    &.warning {
      color: ${Colors.ORANGE5};
    }
  }

  .bp4-button-group {
    display: flex;
    justify-content: center;
  }
`;
