/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package archived

import (
	"github.com/apache/incubator-devlake/plugins/helper"
)

type EpicResponse struct {
	Id    int
	Title string
	Value string
}

type TestConnectionRequest struct {
	Endpoint         string `json:"endpoint"`
	Proxy            string `json:"proxy"`
	helper.BasicAuth `mapstructure:",squash"`
}

type BoardResponse struct {
	Id    int
	Title string
	Value string
}
type TransformationRules struct {
	PrType               string `mapstructure:"prType" json:"prType"`
	PrComponent          string `mapstructure:"prComponent" json:"prComponent"`
	PrBodyClosePattern   string `mapstructure:"prBodyClosePattern" json:"prBodyClosePattern"`
	IssueSeverity        string `mapstructure:"issueSeverity" json:"issueSeverity"`
	IssuePriority        string `mapstructure:"issuePriority" json:"issuePriority"`
	IssueComponent       string `mapstructure:"issueComponent" json:"issueComponent"`
	IssueTypeBug         string `mapstructure:"issueTypeBug" json:"issueTypeBug"`
	IssueTypeIncident    string `mapstructure:"issueTypeIncident" json:"issueTypeIncident"`
	IssueTypeRequirement string `mapstructure:"issueTypeRequirement" json:"issueTypeRequirement"`
}

type ApiUserResponse struct {
	Username      string `json:"username"`
	DisplayName   string `json:"display_name"`
	AccountId     int    `json:"account_id"`
	Uuid          string `json:"uuid"`
	AccountStatus string `json:"account_status"`
}

type BitbucketConnection struct {
	helper.RestConnection      `mapstructure:",squash"`
	helper.BasicAuth           `mapstructure:",squash"`
	RemotelinkCommitShaPattern string `gorm:"type:varchar(255);comment='golang regexp, the first group will be recognized as commit sha, ref https://github.com/google/re2/wiki/Syntax'" json:"remotelinkCommitShaPattern"`
}

func (BitbucketConnection) TableName() string {
	return "_tool_bitbucket_connections"
}
