# Deploy devlake with helm

## Prerequest

- Helm >= 3.6.0
- Kubernetes >= 1.19.0


## Quick Install

clone the code, and enter the deployment/helm folder.
```
helm install devlake . --set service.grafanaEndpoint=http://YOUR-NODE-IP:32000
```

And visit your devlake from the node port (32001 by default).

http://YOUR-NODE-IP:32001


## Some example deployments

### Deploy with NodePort

Conditions:
 - IP Address of Kubernetes node: 192.168.0.6
 - Want to visit devlake with port 30000, and grafana at port 30001

```
helm install devlake . --set "service.uiPort=30000,service.grafanaPort=30001,service.grafanaEndpoint=http://192.168.0.6:30001"
```

After deployed, visit devlake: http://192.168.0.6:30000

### Deploy with Ingress

Conditions:
 - I have already configured default ingress for the Kubernetes cluster
 - I want to use http://devlake.example.com for visiting devlake

```
helm install devlake . --set "ingress.enabled=true,ingress.hostname=devlake.example.com"
```

After deployed, visit devlake: http://devlake.example.com, and grafana at http://devlake.example.com/grafana

### Deploy with Ingress (Https)

Conditions:
 - I have already configured ingress(class: nginx) for the Kubernetes cluster, and the https using 8443 port.
 - I want to use https://devlake-0.example.com:8443 for visiting devlake.
 - The https certificates are generated by letsencrypt.org, and the certificate and key files: `cert.pem` and `key.pem`

First, create the secret:
```
kubectl create secret tls ssl-certificate --cert cert.pem --key secret.pem
```

Then, deploy the devlake:
```
helm install devlake . \
    --set "ingress.enabled=true,ingress.enableHttps=true,ingress.hostname=devlake-0.example.com" \
    --set "ingress.className=nginx,ingress.httpsPort=8443" \
    --set "ingress.tlsSecretName=ssl-certificate"
```

After deployed, visit devlake: https://devlake-0.example.com:8443, and grafana at https://devlake-0.example.com:8443/grafana


## Parameters

Some useful parameters for the chart, you could also check them in values.yaml

| Parameter | Description | Default |
|-----------|-------------|---------|
| replicaCount  | Replica Count for devlake, currently not used  | 1  |
| mysql.useExternal  | If use external mysql server, currently not used  |  false  |
| mysql.externalServer  | External mysql server address  | 127.0.0.1  |
| mysql.externalPort  | External mysql server port  | 3306  |
| mysql.username  | username for mysql | merico  |
| mysql.password  | password for mysql | merico  |
| mysql.database  | database for mysql | lake  |
| mysql.rootPassword  | root password for mysql | admin  |
| mysql.storage.class  | storage class for mysql's volume | ""  |
| mysql.storage.size  | volume size for mysql's data | 5Gi  |
| mysql.image.repository  | repository for mysql's image | mysql  |
| mysql.image.tag  | image tag for mysql's image | 8.0.26  |
| mysql.image.pullPolicy  | pullPolicy for mysql's image | IfNotPresent  |
| grafana.image.repository  | repository for grafana's image | mericodev/grafana  |
| grafana.image.tag  | image tag for grafana's image | latest  |
| grafana.image.pullPolicy  | pullPolicy for grafana's image | Always  |
| lake.storage.class  | storage class for lake's volume | ""  |
| lake.storage.size  | volume size for lake's data | 100Mi  |
| lake.image.repository  | repository for lake's image | mericodev/lake  |
| lake.image.tag  | image tag for lake's image | latest  |
| lake.image.pullPolicy  | pullPolicy for lake's image | Always  |
| ui.image.repository  | repository for ui's image | mericodev/config-ui  |
| ui.image.tag  | image tag for ui's image | latest  |
| ui.image.pullPolicy  | pullPolicy for ui's image | Always  |
| service.type  | Service type for exposed service | NodePort  |
| service.grafanaPort  | Service port for grafana | 32000  |
| service.uiPort  | Service port for config ui | 32001  |
| service.grafanaEndpoint  | The external grafana endpoint, used when ingress not configured  |  http://127.0.0.1:32000  |
| service.ingress.enabled  | If enable ingress  |  false  |
| service.ingress.enableHttps  | If enable https  |  false  |
| service.ingress.className  | The class name for ingressClass. If leave empty, the default IngressClass will be used  | ""  |
| service.ingress.hostname  | The hostname/domainname for ingress  | localhost  |
| service.ingress.prefix | The prefix for endpoints, currently not supported due to devlake's implementation  | /  |
| service.ingress.tlsSecretName  | The secret name for tls's certificate, required when https enabled  | ""  |
| service.ingress.httpPort  | The http port for ingress  | 80  |
| service.ingress.httpsPort  | The https port for ingress  | 443  |
| option.localtime  | The hostpath for mount as /etc/localtime | /etc/localtime  |

