// Package docs GENERATED BY SWAG; DO NOT EDIT
// This file was generated by swaggo/swag
package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "license": {
            "name": "Apache-2.0"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/blueprints": {
            "get": {
                "description": "get blueprints",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Blueprints"
                ],
                "summary": "get blueprints",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/gin.H"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "description": "post blueprints",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Blueprints"
                ],
                "summary": "post blueprints",
                "parameters": [
                    {
                        "description": "json",
                        "name": "blueprint",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "string"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Blueprint"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/blueprints/{blueprintId}": {
            "get": {
                "description": "get blueprints",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Blueprints"
                ],
                "summary": "get blueprints",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "blueprint id",
                        "name": "blueprintId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Blueprint"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "description": "Delete BluePrints",
                "tags": [
                    "Blueprints"
                ],
                "summary": "delete blueprints",
                "parameters": [
                    {
                        "type": "string",
                        "description": "blueprintId",
                        "name": "blueprintId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "patch": {
                "description": "patch blueprints",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Blueprints"
                ],
                "summary": "patch blueprints",
                "parameters": [
                    {
                        "type": "string",
                        "description": "blueprintId",
                        "name": "blueprintId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Blueprint"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/domainlayer/repos": {
            "get": {
                "description": "Get all repos from database",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Domainlayer"
                ],
                "summary": "Get all repos from database",
                "responses": {
                    "200": {
                        "description": "{\"repos\": repos, \"count\": count}",
                        "schema": {
                            "$ref": "#/definitions/gin.H"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/ping": {
            "get": {
                "description": "check http status",
                "tags": [
                    "Ping"
                ],
                "summary": "Ping",
                "responses": {
                    "200": {
                        "description": ""
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/pipelines": {
            "get": {
                "description": "GET /pipelines?status=TASK_RUNNING\u0026pending=1\u0026page=1\u0026pagesize=10\nRETURN SAMPLE\n{\n\"pipelines\": [\n{\"id\": 1, \"name\": \"test-pipeline\", ...}\n],\n\"count\": 5\n}",
                "tags": [
                    "pipelines"
                ],
                "summary": "Get list of pipelines",
                "parameters": [
                    {
                        "type": "string",
                        "description": "query",
                        "name": "status",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "query",
                        "name": "pending",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "query",
                        "name": "page",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "query",
                        "name": "pagesize",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Pipeline"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "description": "Create and run a new pipeline\nRETURN SAMPLE\n{\n\"name\": \"name-of-pipeline\",\n\"tasks\": [\n[ {\"plugin\": \"gitlab\", ...}, {\"plugin\": \"jira\"} ],\n[ {\"plugin\": \"github\", ...}],\n]\n}",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "pipelines"
                ],
                "summary": "Create and run a new pipeline",
                "parameters": [
                    {
                        "description": "json",
                        "name": "pipeline",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "string"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Pipeline"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/pipelines/{pipelineId}": {
            "get": {
                "description": "GET /pipelines/:pipelineId\nRETURN SAMPLE\n{\n\"id\": 1,\n\"name\": \"test-pipeline\",\n...\n}",
                "tags": [
                    "pipelines"
                ],
                "parameters": [
                    {
                        "type": "integer",
                        "description": "query",
                        "name": "pipelineId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.Pipeline"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "description": "Cancel a pending pipeline",
                "tags": [
                    "pipelines"
                ],
                "parameters": [
                    {
                        "type": "integer",
                        "description": "pipeline ID",
                        "name": "pipelineId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": ""
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/pipelines/{pipelineId}/tasks": {
            "get": {
                "description": "get task\nSAMPLE\n{\n\"tasks\": [\n{\"id\": 1, \"plugin\": \"\", ...}\n],\n\"count\": 5\n}",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "task"
                ],
                "summary": "Get task",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "pipelineId",
                        "name": "pipelineId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"tasks\": tasks, \"count\": count}",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/push/{tableName}": {
            "post": {
                "description": "POST /push/:tableName",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "push"
                ],
                "summary": "POST /push/:tableName",
                "parameters": [
                    {
                        "type": "string",
                        "description": "table name",
                        "name": "tableName",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "data",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "string"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"rowsAffected\": rowsAffected}",
                        "schema": {
                            "$ref": "#/definitions/gin.H"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/version": {
            "get": {
                "description": "return a object",
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "version"
                ],
                "summary": "Get the version of lake",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "500": {
                        "description": "Internel Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "gin.H": {
            "type": "object",
            "additionalProperties": true
        },
        "models.Blueprint": {
            "type": "object",
            "required": [
                "cronConfig",
                "name",
                "tasks"
            ],
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "cronConfig": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "tasks": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "updatedAt": {
                    "type": "string"
                }
            }
        },
        "models.Pipeline": {
            "type": "object",
            "properties": {
                "beganAt": {
                    "type": "string"
                },
                "blueprintId": {
                    "type": "integer"
                },
                "createdAt": {
                    "type": "string"
                },
                "finishedAt": {
                    "type": "string"
                },
                "finishedTasks": {
                    "description": "Deprecated",
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "spentSeconds": {
                    "type": "integer"
                },
                "stage": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "tasks": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "totalTasks": {
                    "type": "integer"
                },
                "updatedAt": {
                    "type": "string"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "0.1",
	Host:             "localhost:8080",
	BasePath:         "/",
	Schemes:          []string{},
	Title:            "DevLake Swagger API",
	Description:      "<h2>This is the main page of devlake api</h2>",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
