/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.tcp;

import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCServerEndpoint;
import com.ibm.narpc.NaRPCServerGroup;
import com.ibm.narpc.NaRPCService;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.storage.StorageResource;
import org.apache.crail.storage.StorageServer;
import org.apache.crail.storage.StorageUtils;
import org.apache.crail.storage.tcp.TcpStorageConstants;
import org.apache.crail.storage.tcp.TcpStorageRequest;
import org.apache.crail.storage.tcp.TcpStorageResponse;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpStorageServer
implements Runnable,
StorageServer,
NaRPCService<TcpStorageRequest, TcpStorageResponse> {
    private static final Logger LOG = CrailUtils.getLogger();
    private NaRPCServerGroup<TcpStorageRequest, TcpStorageResponse> serverGroup;
    private NaRPCServerEndpoint<TcpStorageRequest, TcpStorageResponse> serverEndpoint;
    private InetSocketAddress address;
    private boolean alive;
    private long regions;
    private long keys;
    private ConcurrentHashMap<Integer, ByteBuffer> dataBuffers;
    private String dataDirPath;

    public void init(CrailConfiguration conf, String[] args) throws Exception {
        TcpStorageConstants.init(conf, args);
        this.serverGroup = new NaRPCServerGroup((NaRPCService)this, TcpStorageConstants.STORAGE_TCP_QUEUE_DEPTH, (int)CrailConstants.BLOCK_SIZE * 2, false, TcpStorageConstants.STORAGE_TCP_CORES);
        this.serverEndpoint = this.serverGroup.createServerEndpoint();
        this.address = StorageUtils.getDataNodeAddress((String)TcpStorageConstants.STORAGE_TCP_INTERFACE, (int)TcpStorageConstants.STORAGE_TCP_PORT);
        this.serverEndpoint.bind(this.address);
        this.alive = false;
        this.regions = TcpStorageConstants.STORAGE_TCP_STORAGE_LIMIT / TcpStorageConstants.STORAGE_TCP_ALLOCATION_SIZE;
        this.keys = 0L;
        this.dataBuffers = new ConcurrentHashMap();
        this.dataDirPath = StorageUtils.getDatanodeDirectory((String)TcpStorageConstants.STORAGE_TCP_DATA_PATH, (InetSocketAddress)this.address);
        StorageUtils.clean((String)TcpStorageConstants.STORAGE_TCP_DATA_PATH, (String)this.dataDirPath);
    }

    public void printConf(Logger logger) {
        TcpStorageConstants.printConf(logger);
    }

    public StorageResource allocateResource() throws Exception {
        StorageResource resource = null;
        if (this.keys < this.regions) {
            int fileId = (int)this.keys++;
            String dataFilePath = Paths.get(this.dataDirPath, Integer.toString(fileId)).toString();
            RandomAccessFile dataFile = new RandomAccessFile(dataFilePath, "rw");
            FileChannel dataChannel = dataFile.getChannel();
            MappedByteBuffer buffer = dataChannel.map(FileChannel.MapMode.READ_WRITE, 0L, TcpStorageConstants.STORAGE_TCP_ALLOCATION_SIZE);
            this.dataBuffers.put(fileId, buffer);
            dataFile.close();
            dataChannel.close();
            long address = CrailUtils.getAddress((ByteBuffer)buffer);
            resource = StorageResource.createResource((long)address, (int)buffer.capacity(), (int)fileId);
        }
        return resource;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void run() {
        try {
            LOG.info("running TCP storage server, address " + this.address);
            this.alive = true;
            while (true) {
                NaRPCServerChannel endpoint = this.serverEndpoint.accept();
                LOG.info("new connection " + endpoint.address());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public TcpStorageRequest createRequest() {
        return new TcpStorageRequest();
    }

    public TcpStorageResponse processRequest(TcpStorageRequest request) {
        if (request.type() == 2) {
            TcpStorageRequest.WriteRequest writeRequest = request.getWriteRequest();
            ByteBuffer buffer = this.dataBuffers.get(writeRequest.getKey()).duplicate();
            long offset = writeRequest.getAddress() - CrailUtils.getAddress((ByteBuffer)buffer);
            buffer.clear().position((int)offset);
            buffer.put(writeRequest.getBuffer());
            TcpStorageResponse.WriteResponse writeResponse = new TcpStorageResponse.WriteResponse(writeRequest.length());
            return new TcpStorageResponse(writeResponse);
        }
        if (request.type() == 1) {
            TcpStorageRequest.ReadRequest readRequest = request.getReadRequest();
            ByteBuffer buffer = this.dataBuffers.get(readRequest.getKey()).duplicate();
            long offset = readRequest.getAddress() - CrailUtils.getAddress((ByteBuffer)buffer);
            long limit = offset + (long)readRequest.length();
            buffer.clear().position((int)offset).limit((int)limit);
            TcpStorageResponse.ReadResponse readResponse = new TcpStorageResponse.ReadResponse(buffer);
            return new TcpStorageResponse(readResponse);
        }
        LOG.info("processing unknown request");
        return new TcpStorageResponse(1);
    }

    public void addEndpoint(NaRPCServerChannel channel) {
    }

    public void removeEndpoint(NaRPCServerChannel channel) {
    }
}

