/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.tcp;

import com.ibm.narpc.NaRPCEndpoint;
import com.ibm.narpc.NaRPCFuture;
import com.ibm.narpc.NaRPCMessage;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.crail.CrailBuffer;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.tcp.TcpStorageFuture;
import org.apache.crail.storage.tcp.TcpStorageRequest;
import org.apache.crail.storage.tcp.TcpStorageResponse;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpStorageEndpoint
implements StorageEndpoint {
    private static final Logger LOG = CrailUtils.getLogger();
    private NaRPCEndpoint<TcpStorageRequest, TcpStorageResponse> endpoint;

    public TcpStorageEndpoint(NaRPCEndpoint<TcpStorageRequest, TcpStorageResponse> endpoint) {
        this.endpoint = endpoint;
    }

    public void connect(InetSocketAddress address) throws IOException {
        this.endpoint.connect(address);
    }

    public void close() throws IOException, InterruptedException {
        this.endpoint.close();
    }

    public boolean isLocal() {
        return false;
    }

    public StorageFuture read(CrailBuffer buffer, BlockInfo block, long offset) throws IOException, InterruptedException {
        TcpStorageRequest.ReadRequest readReq = new TcpStorageRequest.ReadRequest(block.getLkey(), block.getAddr() + offset, buffer.remaining());
        TcpStorageResponse.ReadResponse readResp = new TcpStorageResponse.ReadResponse(buffer.getByteBuffer());
        TcpStorageRequest req = new TcpStorageRequest(readReq);
        TcpStorageResponse resp = new TcpStorageResponse(readResp);
        NaRPCFuture narpcFuture = this.endpoint.issueRequest((NaRPCMessage)req, (NaRPCMessage)resp);
        return new TcpStorageFuture((NaRPCFuture<TcpStorageRequest, TcpStorageResponse>)narpcFuture, readReq.length());
    }

    public StorageFuture write(CrailBuffer buffer, BlockInfo block, long offset) throws IOException, InterruptedException {
        TcpStorageRequest.WriteRequest writeReq = new TcpStorageRequest.WriteRequest(block.getLkey(), block.getAddr() + offset, buffer.remaining(), buffer.getByteBuffer());
        TcpStorageResponse.WriteResponse writeResp = new TcpStorageResponse.WriteResponse();
        TcpStorageRequest req = new TcpStorageRequest(writeReq);
        TcpStorageResponse resp = new TcpStorageResponse(writeResp);
        NaRPCFuture narpcFuture = this.endpoint.issueRequest((NaRPCMessage)req, (NaRPCMessage)resp);
        return new TcpStorageFuture((NaRPCFuture<TcpStorageRequest, TcpStorageResponse>)narpcFuture, writeReq.length());
    }
}

