/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.rpc;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeStatistics;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.rpc.RpcCreateFile;
import org.apache.crail.rpc.RpcDeleteFile;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcGetFile;
import org.apache.crail.rpc.RpcGetLocation;
import org.apache.crail.rpc.RpcPing;
import org.apache.crail.rpc.RpcProtocol;
import org.apache.crail.rpc.RpcRenameFile;
import org.apache.crail.rpc.RpcVoid;

public class RpcResponseMessage {

    public static class PingNameNodeRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcPing {
        public static int CSIZE = 4;
        private int data = 0;
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 9;
        }

        public int write(ByteBuffer buffer) {
            buffer.putInt(this.data);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.data = buffer.getInt();
        }

        public int getData() {
            return this.data;
        }

        public void setData(int data) {
            this.data = data;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }

    public static class GetDataNodeRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcGetDataNode {
        public static int CSIZE = 12;
        private DataNodeStatistics statistics = new DataNodeStatistics();

        public void setError(short error) {
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 10;
        }

        public int write(ByteBuffer buffer) {
            int written = this.statistics.write(buffer);
            return written;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.statistics.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public DataNodeStatistics getStatistics() {
            return this.statistics;
        }

        public void setFreeBlockCount(int blockCount) {
            this.statistics.setFreeBlockCount(blockCount);
        }

        public short getError() {
            return 0;
        }

        public void setServiceId(long serviceId) {
            this.statistics.setServiceId(serviceId);
        }
    }

    public static class GetLocationRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcGetLocation {
        public static int CSIZE = BlockInfo.CSIZE + 8;
        private BlockInfo blockInfo = new BlockInfo();
        protected long fd = 0L;
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 7;
        }

        public int write(ByteBuffer buffer) {
            int written = this.blockInfo.write(buffer);
            return written;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.blockInfo.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public BlockInfo getBlockInfo() throws IOException {
            return this.blockInfo;
        }

        public void setBlockInfo(BlockInfo blockInfo) {
            if (blockInfo != null) {
                this.blockInfo.setBlockInfo(blockInfo);
            }
        }

        public long getFd() {
            return this.fd;
        }

        public void setFd(long fd) {
            this.fd = fd;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }

    public static class GetBlockRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcGetBlock {
        public static int CSIZE = BlockInfo.CSIZE;
        private BlockInfo blockInfo = new BlockInfo();
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 6;
        }

        public int write(ByteBuffer buffer) {
            int written = this.blockInfo.write(buffer);
            return written;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.blockInfo.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public BlockInfo getBlockInfo() {
            return this.blockInfo;
        }

        public void setBlockInfo(BlockInfo blockInfo) {
            if (blockInfo != null) {
                this.blockInfo.setBlockInfo(blockInfo);
            }
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }

    public static class RenameRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcRenameFile {
        public static int CSIZE = 176 + BlockInfo.CSIZE * 2;
        private FileInfo srcParent = new FileInfo();
        private FileInfo srcFile = new FileInfo();
        private BlockInfo srcBlock = new BlockInfo();
        private FileInfo dstParent = new FileInfo();
        private FileInfo dstFile = new FileInfo();
        private BlockInfo dstBlock = new BlockInfo();
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 5;
        }

        public int write(ByteBuffer buffer) {
            int written = this.srcParent.write(buffer, false);
            written += this.srcFile.write(buffer, false);
            written += this.srcBlock.write(buffer);
            written += this.dstParent.write(buffer, false);
            written += this.dstFile.write(buffer, false);
            return written += this.dstBlock.write(buffer);
        }

        public void update(ByteBuffer buffer) {
            try {
                this.srcParent.update(buffer);
                this.srcFile.update(buffer);
                this.srcBlock.update(buffer);
                this.dstParent.update(buffer);
                this.dstFile.update(buffer);
                this.dstBlock.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public FileInfo getSrcParent() {
            return this.srcParent;
        }

        public FileInfo getSrcFile() {
            return this.srcFile;
        }

        public FileInfo getDstParent() {
            return this.dstParent;
        }

        public FileInfo getDstFile() {
            return this.dstFile;
        }

        public void setSrcParent(FileInfo srcParent) {
            if (srcParent != null) {
                this.srcParent.setFileInfo(srcParent);
            }
        }

        public void setSrcFile(FileInfo srcFile) {
            if (srcFile != null) {
                this.srcFile.setFileInfo(srcFile);
            }
        }

        public void setDstParent(FileInfo dstParent) {
            if (dstParent != null) {
                this.dstParent.setFileInfo(dstParent);
            }
        }

        public void setDstFile(FileInfo dstFile) {
            if (dstFile != null) {
                this.dstFile.setFileInfo(dstFile);
            }
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }

        public void setSrcBlock(BlockInfo srcBlock) {
            if (srcBlock != null) {
                this.srcBlock.setBlockInfo(srcBlock);
            }
        }

        public void setDstBlock(BlockInfo dstBlock) {
            if (dstBlock != null) {
                this.dstBlock.setBlockInfo(dstBlock);
            }
        }

        public BlockInfo getSrcBlock() {
            return this.srcBlock;
        }

        public BlockInfo getDstBlock() {
            return this.dstBlock;
        }
    }

    public static class DeleteFileRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcDeleteFile {
        public static int CSIZE = 88;
        private FileInfo fileInfo = new FileInfo();
        private FileInfo parentInfo = new FileInfo();
        private boolean shipToken = false;
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 4;
        }

        public int write(ByteBuffer buffer) {
            int written = this.fileInfo.write(buffer, this.shipToken);
            return written += this.parentInfo.write(buffer, false);
        }

        public void update(ByteBuffer buffer) {
            try {
                this.fileInfo.update(buffer);
                this.parentInfo.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public FileInfo getFile() {
            return this.fileInfo;
        }

        public FileInfo getParent() {
            return this.parentInfo;
        }

        public void setFileInfo(FileInfo fileInfo) {
            if (fileInfo != null) {
                this.fileInfo.setFileInfo(fileInfo);
                this.shipToken = false;
            }
        }

        public void setParentInfo(FileInfo parentInfo) {
            if (parentInfo != null) {
                this.parentInfo.setFileInfo(parentInfo);
            }
        }

        public void shipToken() {
            this.shipToken = true;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }

    public static class GetFileRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcGetFile {
        public static int CSIZE = 44 + BlockInfo.CSIZE;
        private FileInfo fileInfo = new FileInfo();
        private BlockInfo fileBlock = new BlockInfo();
        private boolean shipToken = false;
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 3;
        }

        public int write(ByteBuffer buffer) {
            int written = this.fileInfo.write(buffer, this.shipToken);
            return written += this.fileBlock.write(buffer);
        }

        public void update(ByteBuffer buffer) {
            try {
                this.fileInfo.update(buffer);
                this.fileBlock.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public FileInfo getFile() {
            return this.fileInfo;
        }

        public void setFileInfo(FileInfo fileInfo) {
            if (fileInfo != null) {
                this.fileInfo.setFileInfo(fileInfo);
                this.shipToken = false;
            }
        }

        public BlockInfo getFileBlock() {
            return this.fileBlock;
        }

        public void setFileBlock(BlockInfo blockInfo) {
            if (blockInfo != null) {
                this.fileBlock.setBlockInfo(blockInfo);
            }
        }

        public void shipToken() {
            this.shipToken = true;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }

    public static class CreateFileRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcCreateFile {
        public static int CSIZE = 88 + BlockInfo.CSIZE * 2;
        private FileInfo fileInfo = new FileInfo();
        private FileInfo parentInfo = new FileInfo();
        private BlockInfo fileBlock = new BlockInfo();
        private BlockInfo dirBlock = new BlockInfo();
        private boolean shipToken = false;
        private short error = 0;

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 2;
        }

        public int write(ByteBuffer buffer) {
            int written = this.fileInfo.write(buffer, this.shipToken);
            written += this.parentInfo.write(buffer, false);
            written += this.fileBlock.write(buffer);
            return written += this.dirBlock.write(buffer);
        }

        public void update(ByteBuffer buffer) {
            try {
                this.fileInfo.update(buffer);
                this.parentInfo.update(buffer);
                this.fileBlock.update(buffer);
                this.dirBlock.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public FileInfo getFile() {
            return this.fileInfo;
        }

        public void setFileInfo(FileInfo fileInfo) {
            if (fileInfo != null) {
                this.fileInfo.setFileInfo(fileInfo);
            }
        }

        public FileInfo getParent() {
            return this.parentInfo;
        }

        public void setParentInfo(FileInfo parentInfo) {
            if (parentInfo != null) {
                this.parentInfo.setFileInfo(parentInfo);
            }
        }

        public BlockInfo getFileBlock() {
            return this.fileBlock;
        }

        public void setFileBlock(BlockInfo blockInfo) {
            if (blockInfo != null) {
                this.fileBlock.setBlockInfo(blockInfo);
            }
        }

        public BlockInfo getDirBlock() {
            return this.dirBlock;
        }

        public void setDirBlock(BlockInfo blockInfo) {
            if (blockInfo != null) {
                this.dirBlock.setBlockInfo(blockInfo);
            }
        }

        public void shipToken(boolean value) {
            this.shipToken = value;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }

        public boolean isShipToken() {
            return this.shipToken;
        }
    }

    public static class VoidRes
    implements RpcProtocol.NameNodeRpcMessage,
    RpcVoid {
        private short error = 0;

        public int size() {
            return 0;
        }

        @Override
        public short getType() {
            return 1;
        }

        public void update(ByteBuffer buffer) {
        }

        public int write(ByteBuffer buffer) {
            return 0;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }
    }
}

