/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.rpc;

import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RpcProtocol
extends RpcErrors {
    private static final Logger LOG = CrailUtils.getLogger();
    public static short[] requestTypes = new short[16];
    public static short[] responseTypes = new short[16];
    public static final short CMD_CREATE_FILE = 1;
    public static final short CMD_GET_FILE = 2;
    public static final short CMD_SET_FILE = 3;
    public static final short CMD_REMOVE_FILE = 4;
    public static final short CMD_RENAME_FILE = 5;
    public static final short CMD_GET_BLOCK = 6;
    public static final short CMD_GET_LOCATION = 7;
    public static final short CMD_SET_BLOCK = 8;
    public static final short CMD_DUMP_NAMENODE = 10;
    public static final short CMD_PING_NAMENODE = 11;
    public static final short CMD_GET_DATANODE = 12;
    public static final short REQ_CREATE_FILE = 1;
    public static final short REQ_GET_FILE = 2;
    public static final short REQ_SET_FILE = 3;
    public static final short REQ_REMOVE_FILE = 4;
    public static final short REQ_RENAME_FILE = 5;
    public static final short REQ_GET_BLOCK = 6;
    public static final short REQ_GET_LOCATION = 7;
    public static final short REQ_SET_BLOCK = 8;
    public static final short REQ_DUMP_NAMENODE = 10;
    public static final short REQ_PING_NAMENODE = 11;
    public static final short REQ_GET_DATANODE = 12;
    public static final short RES_VOID = 1;
    public static final short RES_CREATE_FILE = 2;
    public static final short RES_GET_FILE = 3;
    public static final short RES_DELETE_FILE = 4;
    public static final short RES_RENAME_FILE = 5;
    public static final short RES_GET_BLOCK = 6;
    public static final short RES_GET_LOCATION = 7;
    public static final short RES_PING_NAMENODE = 9;
    public static final short RES_GET_DATANODE = 10;

    public static boolean verifyProtocol(short cmd, NameNodeRpcMessage request, NameNodeRpcMessage response) {
        if (request.getType() != requestTypes[cmd]) {
            LOG.info("protocol mismatch, cmd " + cmd + ", request.type " + request.getType() + ", response.type " + response.getType());
            return false;
        }
        if (response.getType() != responseTypes[cmd]) {
            LOG.info("protocol mismatch, cmd " + cmd + ", request.type " + request.getType() + ", response.type " + response.getType());
            return false;
        }
        return true;
    }

    static {
        RpcProtocol.requestTypes[0] = 0;
        RpcProtocol.requestTypes[1] = 1;
        RpcProtocol.requestTypes[2] = 2;
        RpcProtocol.requestTypes[3] = 3;
        RpcProtocol.requestTypes[4] = 4;
        RpcProtocol.requestTypes[5] = 5;
        RpcProtocol.requestTypes[6] = 6;
        RpcProtocol.requestTypes[7] = 7;
        RpcProtocol.requestTypes[8] = 8;
        RpcProtocol.requestTypes[10] = 10;
        RpcProtocol.requestTypes[11] = 11;
        RpcProtocol.requestTypes[12] = 12;
        RpcProtocol.responseTypes[0] = 0;
        RpcProtocol.responseTypes[1] = 2;
        RpcProtocol.responseTypes[2] = 3;
        RpcProtocol.responseTypes[3] = 1;
        RpcProtocol.responseTypes[4] = 4;
        RpcProtocol.responseTypes[5] = 5;
        RpcProtocol.responseTypes[6] = 6;
        RpcProtocol.responseTypes[7] = 7;
        RpcProtocol.responseTypes[8] = 1;
        RpcProtocol.responseTypes[10] = 1;
        RpcProtocol.responseTypes[11] = 9;
        RpcProtocol.responseTypes[12] = 10;
    }

    public static interface NameNodeRpcMessage {
        public short getType();
    }
}

