/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

public class RingBuffer<T> {
    public T[] elements = null;
    private int size = 0;
    private int writePos = 0;
    private int available = 0;

    public RingBuffer(int capacity) {
        this.size = capacity;
        this.elements = new Object[capacity];
    }

    public void clear() {
        this.writePos = 0;
        this.available = 0;
    }

    public int capacity() {
        return this.size;
    }

    public int size() {
        return this.available;
    }

    public boolean isEmpty() {
        return this.available == 0;
    }

    public int remaining() {
        return this.size - this.available;
    }

    public boolean add(T element) {
        if (this.available < this.size) {
            if (this.writePos >= this.size) {
                this.writePos = 0;
            }
            this.elements[this.writePos] = element;
            ++this.writePos;
            ++this.available;
            return true;
        }
        return false;
    }

    public T poll() {
        if (this.available == 0) {
            return null;
        }
        int nextSlot = this.writePos - this.available;
        if (nextSlot < 0) {
            nextSlot += this.size;
        }
        T nextObj = this.elements[nextSlot];
        --this.available;
        return nextObj;
    }

    public T peek() {
        if (this.available == 0) {
            return null;
        }
        int nextSlot = this.writePos - this.available;
        if (nextSlot < 0) {
            nextSlot += this.size;
        }
        T nextObj = this.elements[nextSlot];
        return nextObj;
    }
}

