/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.conf.CrailConstants;

public abstract class MultiFuture<R, T>
implements Future<T> {
    protected static int RPC_PENDING = 0;
    protected static int RPC_DONE = 1;
    protected static int RPC_ERROR = 2;
    private LinkedBlockingQueue<Future<R>> pendingDataOps = new LinkedBlockingQueue();
    private AtomicInteger status = new AtomicInteger(RPC_PENDING);
    private Exception exception = null;

    public abstract void aggregate(R var1);

    public abstract T getAggregate();

    @Override
    public synchronized boolean isDone() {
        if (this.status.get() == RPC_PENDING) {
            try {
                Future<R> dataFuture = this.pendingDataOps.peek();
                while (dataFuture != null && dataFuture.isDone()) {
                    dataFuture = this.pendingDataOps.poll();
                    R result = dataFuture.get();
                    this.aggregate(result);
                    dataFuture = this.pendingDataOps.peek();
                }
                if (this.pendingDataOps.isEmpty() && this.status.get() == RPC_PENDING) {
                    this.completeOperation();
                }
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        return this.status.get() > 0;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.status.get() == RPC_PENDING) {
            try {
                Future<R> dataFuture = this.pendingDataOps.poll();
                while (dataFuture != null) {
                    R result = dataFuture.get();
                    this.aggregate(result);
                    dataFuture = this.pendingDataOps.poll();
                }
                this.completeOperation();
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.getAggregate();
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.status.get() == RPC_PENDING) {
            try {
                Future<R> dataFuture = this.pendingDataOps.poll();
                while (dataFuture != null) {
                    R result = dataFuture.get(CrailConstants.DATA_TIMEOUT, TimeUnit.MILLISECONDS);
                    this.aggregate(result);
                    dataFuture = this.pendingDataOps.poll();
                }
                this.completeOperation();
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.getAggregate();
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public synchronized void add(Future<R> dataFuture) {
        this.pendingDataOps.add(dataFuture);
    }

    public void completeOperation() {
        if (this.status.get() != RPC_DONE) {
            this.status.set(RPC_DONE);
        }
    }
}

