/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.tools;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.CrailBufferedOutputStream;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.CrailResult;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.CrailStore;
import org.apache.crail.Upcoming;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.OffHeapBuffer;
import org.apache.crail.utils.CrailUtils;
import org.apache.crail.utils.RingBuffer;

public class CrailBenchmark {
    private int warmup;
    private CrailConfiguration conf;
    private CrailStore fs;

    public CrailBenchmark(int warmup) throws Exception {
        this.warmup = warmup;
        this.conf = CrailConfiguration.createConfigurationFromFile();
        this.fs = null;
    }

    private void open() throws Exception {
        if (this.fs == null) {
            this.fs = CrailStore.newInstance(this.conf);
        }
    }

    private void close() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    void write(String filename, int size, int loop, int storageClass, int locationClass, boolean buffered, boolean skipDir) throws Exception {
        double ops;
        System.out.println("write, filename " + filename + ", size " + size + ", loop " + loop + ", storageClass " + storageClass + ", locationClass " + locationClass + ", buffered " + buffered);
        CrailBuffer buf = null;
        if (size == CrailConstants.BUFFER_SIZE) {
            buf = this.fs.allocateBuffer();
        } else if (size < CrailConstants.BUFFER_SIZE) {
            CrailBuffer _buf = this.fs.allocateBuffer();
            _buf.clear().limit(size);
            buf = _buf.slice();
        } else {
            buf = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
        }
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        long _loop = loop;
        long _bufsize = CrailConstants.BUFFER_SIZE;
        long _capacity = _loop * _bufsize;
        double sumbytes = 0.0;
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.get(storageClass), CrailLocationClass.get(locationClass), !skipDir).get()).asFile();
        CrailBufferedOutputStream bufferedStream = buffered ? file.getBufferedOutputStream(_capacity) : null;
        CrailOutputStream directStream = !buffered ? file.getDirectOutputStream(_capacity) : null;
        long start = System.currentTimeMillis();
        for (ops = 0.0; ops < (double)loop; ops += 1.0) {
            buf.clear();
            if (buffered) {
                bufferedStream.write(buf.getByteBuffer());
            } else {
                directStream.write(buf).get();
            }
            sumbytes += (double)buf.capacity();
        }
        if (buffered) {
            bufferedStream.close();
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1000.0 / 1000.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void writeAsync(String filename, int size, int loop, int batch, int storageClass, int locationClass, boolean skipDir) throws Exception {
        CrailBuffer buf;
        System.out.println("writeAsync, filename " + filename + ", size " + size + ", loop " + loop + ", batch " + batch + ", storageClass " + storageClass + ", locationClass " + locationClass);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        for (int i = 0; i < batch; ++i) {
            CrailBuffer buf2 = null;
            if (size == CrailConstants.BUFFER_SIZE) {
                buf2 = this.fs.allocateBuffer();
            } else if (size < CrailConstants.BUFFER_SIZE) {
                CrailBuffer _buf = this.fs.allocateBuffer();
                _buf.clear().limit(size);
                buf2 = _buf.slice();
            } else {
                buf2 = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
            }
            bufferQueue.add(buf2);
        }
        this.warmUp(filename, this.warmup, bufferQueue);
        System.out.println("starting benchmark...");
        LinkedBlockingQueue<Future> futureQueue = new LinkedBlockingQueue<Future>();
        HashMap<Integer, CrailBuffer> futureMap = new HashMap<Integer, CrailBuffer>();
        this.fs.getStatistics().reset();
        long _loop = loop;
        long _bufsize = CrailConstants.BUFFER_SIZE;
        long _capacity = _loop * _bufsize;
        double sumbytes = 0.0;
        double ops = 0.0;
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.get(storageClass), CrailLocationClass.get(locationClass), !skipDir).get()).asFile();
        CrailOutputStream directStream = file.getDirectOutputStream(_capacity);
        long start = System.currentTimeMillis();
        for (int i = 0; i < batch - 1 && ops < (double)loop; ops += 1.0, ++i) {
            buf = bufferQueue.poll();
            buf.clear();
            Future<CrailResult> future = directStream.write(buf);
            futureQueue.add(future);
            futureMap.put(future.hashCode(), buf);
        }
        while (ops < (double)loop) {
            CrailBuffer buf3 = bufferQueue.poll();
            buf3.clear();
            Future future = directStream.write(buf3);
            futureQueue.add(future);
            futureMap.put(future.hashCode(), buf3);
            future = (Future)futureQueue.poll();
            future.get();
            buf3 = (CrailBuffer)futureMap.get(future.hashCode());
            bufferQueue.add(buf3);
            sumbytes += (double)buf3.capacity();
            ops += 1.0;
        }
        while (!futureQueue.isEmpty()) {
            Future future = (Future)futureQueue.poll();
            future.get();
            buf = (CrailBuffer)futureMap.get(future.hashCode());
            sumbytes += (double)buf.capacity();
            ops += 1.0;
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1000.0 / 1000.0;
            latency = 1000000.0 * executionTime / ops;
        }
        directStream.close();
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void readSequential(String filename, int size, int loop, boolean buffered) throws Exception {
        System.out.println("readSequential, filename " + filename + ", size " + size + ", loop " + loop + ", buffered " + buffered);
        CrailBuffer buf = null;
        if (size == CrailConstants.BUFFER_SIZE) {
            buf = this.fs.allocateBuffer();
        } else if (size < CrailConstants.BUFFER_SIZE) {
            CrailBuffer _buf = this.fs.allocateBuffer();
            _buf.clear().limit(size);
            buf = _buf.slice();
        } else {
            buf = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
        }
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        CrailFile file = ((CrailNode)this.fs.lookup(filename).get()).asFile();
        CrailBufferedInputStream bufferedStream = file.getBufferedInputStream(file.getCapacity());
        CrailInputStream directStream = file.getDirectInputStream(file.getCapacity());
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        double sumbytes = 0.0;
        double ops = 0.0;
        long start = System.currentTimeMillis();
        while (ops < (double)loop) {
            double ret;
            if (buffered) {
                buf.clear();
                ret = bufferedStream.read(buf.getByteBuffer());
                if (ret > 0.0) {
                    sumbytes += ret;
                    ops += 1.0;
                    continue;
                }
                ops += 1.0;
                if (bufferedStream.position() == 0L) break;
                bufferedStream.seek(0L);
                continue;
            }
            buf.clear();
            ret = directStream.read(buf).get().getLen();
            if (ret > 0.0) {
                sumbytes += ret;
                ops += 1.0;
                continue;
            }
            ops += 1.0;
            if (directStream.position() == 0L) break;
            directStream.seek(0L);
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1000.0 / 1000.0;
            latency = 1000000.0 * executionTime / ops;
        }
        bufferedStream.close();
        directStream.close();
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void readRandom(String filename, int size, int loop, boolean buffered) throws Exception {
        System.out.println("readRandom, filename " + filename + ", size " + size + ", loop " + loop + ", buffered " + buffered);
        CrailBuffer buf = null;
        if (size == CrailConstants.BUFFER_SIZE) {
            buf = this.fs.allocateBuffer();
        } else if (size < CrailConstants.BUFFER_SIZE) {
            CrailBuffer _buf = this.fs.allocateBuffer();
            _buf.clear().limit(size);
            buf = _buf.slice();
        } else {
            buf = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
        }
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        CrailFile file = ((CrailNode)this.fs.lookup(filename).get()).asFile();
        CrailBufferedInputStream bufferedStream = file.getBufferedInputStream(file.getCapacity());
        CrailInputStream directStream = file.getDirectInputStream(file.getCapacity());
        double sumbytes = 0.0;
        double ops = 0.0;
        long _range = file.getCapacity() - (long)buf.capacity();
        double range = _range /= (long)size;
        Random random = new Random();
        long start = System.currentTimeMillis();
        while (ops < (double)loop) {
            double ret;
            long offset;
            double _offset;
            if (buffered) {
                buf.clear();
                _offset = range * random.nextDouble();
                offset = (long)_offset * (long)size;
                bufferedStream.seek(offset);
                ret = bufferedStream.read(buf.getByteBuffer());
                if (!(ret > 0.0)) break;
                sumbytes += ret;
                ops += 1.0;
                continue;
            }
            buf.clear();
            _offset = range * random.nextDouble();
            offset = (long)_offset * (long)size;
            directStream.seek(offset);
            ret = directStream.read(buf).get().getLen();
            if (!(ret > 0.0)) break;
            sumbytes += ret;
            ops += 1.0;
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1000.0 / 1000.0;
            latency = 1000000.0 * executionTime / ops;
        }
        bufferedStream.close();
        directStream.close();
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void readSequentialAsync(String filename, int size, int loop, int batch) throws Exception {
        System.out.println("readSequentialAsync, filename " + filename + ", size " + size + ", loop " + loop + ", batch " + batch);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        for (int i = 0; i < batch; ++i) {
            CrailBuffer buf = null;
            if (size == CrailConstants.BUFFER_SIZE) {
                buf = this.fs.allocateBuffer();
            } else if (size < CrailConstants.BUFFER_SIZE) {
                CrailBuffer _buf = this.fs.allocateBuffer();
                _buf.clear().limit(size);
                buf = _buf.slice();
            } else {
                buf = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
            }
            bufferQueue.add(buf);
        }
        this.warmUp(filename, this.warmup, bufferQueue);
        System.out.println("starting benchmark...");
        double sumbytes = 0.0;
        double ops = 0.0;
        this.fs.getStatistics().reset();
        CrailFile file = ((CrailNode)this.fs.lookup(filename).get()).asFile();
        CrailInputStream directStream = file.getDirectInputStream(file.getCapacity());
        HashMap<Integer, CrailBuffer> futureMap = new HashMap<Integer, CrailBuffer>();
        LinkedBlockingQueue<Future> futureQueue = new LinkedBlockingQueue<Future>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < batch - 1 && ops < (double)loop; ops += 1.0, ++i) {
            CrailBuffer buf = bufferQueue.poll();
            buf.clear();
            Future<CrailResult> future = directStream.read(buf);
            futureQueue.add(future);
            futureMap.put(future.hashCode(), buf);
        }
        while (ops < (double)loop) {
            CrailBuffer buf = bufferQueue.poll();
            buf.clear();
            Future future = directStream.read(buf);
            futureQueue.add(future);
            futureMap.put(future.hashCode(), buf);
            future = (Future)futureQueue.poll();
            CrailResult result = (CrailResult)future.get();
            buf = (CrailBuffer)futureMap.get(future.hashCode());
            bufferQueue.add(buf);
            sumbytes += (double)result.getLen();
            ops += 1.0;
        }
        while (!futureQueue.isEmpty()) {
            Future future = (Future)futureQueue.poll();
            CrailResult result = (CrailResult)future.get();
            futureMap.get(future.hashCode());
            sumbytes += (double)result.getLen();
            ops += 1.0;
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1000.0 / 1000.0;
            latency = 1000000.0 * executionTime / ops;
        }
        directStream.close();
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void readMultiStream(String filename, int size, int loop, int batch) throws Exception {
        Object buf;
        System.out.println("readMultiStream, filename " + filename + ", size " + size + ", loop " + loop + ", batch " + batch);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        for (int i = 0; i < this.warmup; ++i) {
            buf = this.fs.allocateBuffer().limit(size).slice();
            bufferQueue.add((CrailBuffer)buf);
        }
        this.warmUp(filename, this.warmup, bufferQueue);
        while (!bufferQueue.isEmpty()) {
            CrailBuffer buf2 = bufferQueue.poll();
            this.fs.freeBuffer(buf2);
        }
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        CrailBuffer _buf = null;
        if (size == CrailConstants.BUFFER_SIZE) {
            _buf = this.fs.allocateBuffer();
        } else if (size < CrailConstants.BUFFER_SIZE) {
            CrailBuffer __buf = this.fs.allocateBuffer();
            __buf.clear().limit(size);
            _buf = __buf.slice();
        } else {
            _buf = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(size));
        }
        buf = _buf.getByteBuffer();
        for (int i = 0; i < loop; ++i) {
            CrailBufferedInputStream multiStream = ((CrailNode)this.fs.lookup(filename).get()).asMultiFile().getMultiStream(batch);
            double sumbytes = 0.0;
            long _sumbytes = 0L;
            double ops = 0.0;
            ((ByteBuffer)buf).clear();
            long start = System.currentTimeMillis();
            int ret = multiStream.read((ByteBuffer)buf);
            while (ret >= 0) {
                sumbytes += (double)ret;
                long _ret = ret;
                _sumbytes += _ret;
                ops += 1.0;
                ((ByteBuffer)buf).clear();
                ret = multiStream.read((ByteBuffer)buf);
            }
            long end = System.currentTimeMillis();
            multiStream.close();
            double executionTime = (double)(end - start) / 1000.0;
            double throughput = 0.0;
            double latency = 0.0;
            double sumbits = sumbytes * 8.0;
            if (executionTime > 0.0) {
                throughput = sumbits / executionTime / 1000.0 / 1000.0;
                latency = 1000000.0 * executionTime / ops;
            }
            System.out.println("round " + i + ":");
            System.out.println("bytes read " + _sumbytes);
            System.out.println("execution time " + executionTime);
            System.out.println("ops " + ops);
            System.out.println("throughput " + throughput);
            System.out.println("latency " + latency);
        }
        this.fs.getStatistics().print("close");
    }

    void createFile(String filename, int loop) throws Exception, InterruptedException {
        System.out.println("createFile, filename " + filename + ", loop " + loop);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        CrailBuffer buf = this.fs.allocateBuffer();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        this.fs.freeBuffer(buf);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        LinkedBlockingQueue<String> pathQueue = new LinkedBlockingQueue<String>();
        ((CrailNode)this.fs.create(filename, CrailNodeType.DIRECTORY, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).syncDir();
        int filecounter = 0;
        for (int i = 0; i < loop; ++i) {
            String name = "" + filecounter++;
            String f = filename + "/" + name;
            pathQueue.add(f);
        }
        double ops = 0.0;
        long start = System.currentTimeMillis();
        while (!pathQueue.isEmpty()) {
            String path = (String)pathQueue.poll();
            ((CrailNode)this.fs.create(path, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).syncDir();
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double latency = 0.0;
        if (executionTime > 0.0) {
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
    }

    void createFileAsync(String filename, int loop, int batch) throws Exception, InterruptedException {
        System.out.println("createFileAsync, filename " + filename + ", loop " + loop + ", batch " + batch);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        CrailBuffer buf = this.fs.allocateBuffer();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        this.fs.freeBuffer(buf);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        LinkedBlockingQueue<Upcoming<CrailNode>> futureQueue = new LinkedBlockingQueue<Upcoming<CrailNode>>();
        LinkedBlockingQueue<CrailFile> fileQueue = new LinkedBlockingQueue<CrailFile>();
        LinkedBlockingQueue<String> pathQueue = new LinkedBlockingQueue<String>();
        ((CrailNode)this.fs.create(filename, CrailNodeType.DIRECTORY, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).syncDir();
        for (int i = 0; i < loop; ++i) {
            String name = "/" + i;
            String f = filename + name;
            pathQueue.add(f);
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < loop; i += batch) {
            int j;
            for (j = 0; j < batch; ++j) {
                String path = (String)pathQueue.poll();
                Upcoming<CrailNode> future = this.fs.create(path, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true);
                futureQueue.add(future);
            }
            for (j = 0; j < batch; ++j) {
                Future future = (Future)futureQueue.poll();
                CrailFile file = ((CrailNode)future.get()).asFile();
                fileQueue.add(file);
            }
            for (j = 0; j < batch; ++j) {
                CrailFile file = (CrailFile)fileQueue.poll();
                file.syncDir();
            }
        }
        long end = System.currentTimeMillis();
        double executionTime = end - start;
        double latency = executionTime * 1000.0 / (double)loop;
        System.out.println("execution time [ms] " + executionTime);
        System.out.println("latency [us] " + latency);
        ((CrailNode)this.fs.delete(filename, true).get()).syncDir();
        this.fs.getStatistics().print("close");
    }

    void createMultiFile(String filename, int storageClass) throws Exception, InterruptedException {
        System.out.println("createMultiFile, filename " + filename);
        ((CrailNode)this.fs.create(filename, CrailNodeType.MULTIFILE, CrailStorageClass.get(storageClass), CrailLocationClass.DEFAULT, true).get()).syncDir();
    }

    void getKey(String filename, int size, int loop) throws Exception {
        System.out.println("getKey, path " + filename + ", size " + size + ", loop " + loop);
        CrailBuffer buf = this.fs.allocateBuffer().clear().limit(size).slice();
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        file.syncDir();
        CrailOutputStream directOutputStream = file.getDirectOutputStream(0L);
        directOutputStream.write(buf).get();
        directOutputStream.close();
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        long start = System.currentTimeMillis();
        for (int i = 0; i < loop; ++i) {
            CrailInputStream directInputStream = ((CrailNode)this.fs.lookup(filename).get()).asFile().getDirectInputStream(0L);
            buf.clear();
            directInputStream.read(buf).get();
            directInputStream.close();
        }
        long end = System.currentTimeMillis();
        double executionTime = end - start;
        double latency = executionTime * 1000.0 / (double)loop;
        System.out.println("execution time [ms] " + executionTime);
        System.out.println("latency [us] " + latency);
        this.fs.getStatistics().print("close");
    }

    void getFile(String filename, int loop) throws Exception, InterruptedException {
        double ops;
        System.out.println("getFile, filename " + filename + ", loop " + loop);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        CrailBuffer buf = this.fs.allocateBuffer();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        this.fs.freeBuffer(buf);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        long start = System.currentTimeMillis();
        for (ops = 0.0; ops < (double)loop; ops += 1.0) {
            ((CrailNode)this.fs.lookup(filename).get()).asFile();
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double latency = 0.0;
        if (executionTime > 0.0) {
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("latency " + latency);
        this.fs.getStatistics().print("close");
        this.fs.close();
    }

    void getFileAsync(String filename, int loop, int batch) throws Exception, InterruptedException {
        System.out.println("getFileAsync, filename " + filename + ", loop " + loop + ", batch " + batch);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        CrailBuffer buf = this.fs.allocateBuffer();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        this.fs.freeBuffer(buf);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        LinkedBlockingQueue<Upcoming<CrailNode>> fileQueue = new LinkedBlockingQueue<Upcoming<CrailNode>>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < loop; ++i) {
            Future<CrailNode> future;
            int j;
            for (j = 0; j < batch; ++j) {
                future = this.fs.lookup(filename);
                fileQueue.add((Upcoming<CrailNode>)future);
            }
            for (j = 0; j < batch; ++j) {
                future = (Future)fileQueue.poll();
                future.get();
            }
        }
        long end = System.currentTimeMillis();
        double executionTime = end - start;
        double latency = executionTime * 1000.0 / (double)batch;
        System.out.println("execution time [ms] " + executionTime);
        System.out.println("latency [us] " + latency);
        this.fs.getStatistics().print("close");
    }

    void enumerateDir(String filename, int loop) throws Exception {
        System.out.println("reading enumarate dir, path " + filename);
        ConcurrentLinkedQueue<CrailBuffer> bufferQueue = new ConcurrentLinkedQueue<CrailBuffer>();
        CrailBuffer buf = this.fs.allocateBuffer();
        bufferQueue.add(buf);
        this.warmUp(filename, this.warmup, bufferQueue);
        this.fs.freeBuffer(buf);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        long start = System.currentTimeMillis();
        for (int i = 0; i < loop; ++i) {
            Iterator<String> iter = ((CrailNode)this.fs.lookup(filename).get()).asDirectory().listEntries();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long end = System.currentTimeMillis();
        double executionTime = end - start;
        double latency = executionTime * 1000.0 / (double)loop;
        System.out.println("execution time [ms] " + executionTime);
        System.out.println("latency [us] " + latency);
        this.fs.getStatistics().print("close");
    }

    void browseDir(String filename) throws Exception {
        Iterator<String> iter;
        System.out.println("reading enumarate dir, path " + filename);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        CrailNode node = (CrailNode)this.fs.lookup(filename).get();
        System.out.println("node type is " + (Object)((Object)node.getType()));
        Iterator<String> iterator = iter = node.getType() == CrailNodeType.DIRECTORY ? node.asDirectory().listEntries() : node.asMultiFile().listEntries();
        while (iter.hasNext()) {
            String name = iter.next();
            System.out.println(name);
        }
        this.fs.getStatistics().print("close");
    }

    void early(String filename) throws Exception {
        ByteBuffer buf = ByteBuffer.allocateDirect(32);
        CrailFile file = this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).early().asFile();
        CrailBufferedOutputStream stream = file.getBufferedOutputStream(0L);
        System.out.println("buffered stream initialized");
        Thread.sleep(1000L);
        stream.write(buf);
        System.out.println("buffered stream written");
        Thread.sleep(1000L);
        stream.write(buf);
        System.out.println("buffered stream written");
        stream.purge();
        stream.close();
        System.out.println("buffered stream closed");
        this.fs.getStatistics().print("close");
    }

    void writeInt(String filename, int loop) throws Exception {
        System.out.println("writeInt, filename " + filename + ", loop " + loop);
        System.out.println("starting benchmark...");
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        CrailBufferedOutputStream outputStream = file.getBufferedOutputStream(loop * 4);
        int intValue = 0;
        System.out.println("starting write at position " + outputStream.position());
        for (double ops = 0.0; ops < (double)loop; ops += 1.0) {
            System.out.println("writing position " + outputStream.position() + ", value " + intValue);
            outputStream.writeInt(intValue);
            ++intValue;
        }
        outputStream.purge().get();
        outputStream.sync().get();
        this.fs.getStatistics().print("close");
    }

    void readInt(String filename, int loop) throws Exception {
        System.out.println("seek, filename " + filename + ", loop " + loop);
        System.out.println("starting benchmark...");
        CrailFile file = ((CrailNode)this.fs.lookup(filename).get()).asFile();
        CrailBufferedInputStream inputStream = file.getBufferedInputStream(loop * 4);
        System.out.println("starting read at position " + inputStream.position());
        for (double ops = 0.0; ops < (double)loop; ops += 1.0) {
            System.out.print("reading position " + inputStream.position() + ", expected " + inputStream.position() / 4L + " ");
            int intValue = inputStream.readInt();
            System.out.println(", value " + intValue);
        }
        inputStream.close();
        this.fs.getStatistics().print("close");
    }

    void seekInt(String filename, int loop) throws Exception {
        System.out.println("seek, filename " + filename + ", loop " + loop);
        System.out.println("starting benchmark...");
        CrailFile file = ((CrailNode)this.fs.lookup(filename).get()).asFile();
        Random random = new Random();
        long nbrOfInts = file.getCapacity() / 4L;
        CrailBufferedInputStream seekStream = file.getBufferedInputStream(loop * 4);
        System.out.println("starting seek phase, nbrOfInts " + nbrOfInts + ", position " + seekStream.position());
        long falseMatches = 0L;
        for (double ops = 0.0; ops < (double)loop; ops += 1.0) {
            int intIndex = random.nextInt((int)nbrOfInts);
            int pos = intIndex * 4;
            seekStream.seek(pos);
            int intValue = seekStream.readInt();
            if (intIndex != intValue) {
                ++falseMatches;
                System.out.println("reading, position " + pos + ", expected " + pos / 4 + ", ########## value " + intValue);
                continue;
            }
            System.out.println("reading, position " + pos + ", expected " + pos / 4 + ", value " + intValue);
        }
        seekStream.close();
        long end = System.currentTimeMillis();
        System.out.println("falseMatches " + falseMatches);
        this.fs.getStatistics().print("close");
    }

    void readMultiStreamInt(String filename, int loop, int batch) throws Exception {
        System.out.println("readMultiStreamInt, filename " + filename + ", loop " + loop + ", batch " + batch);
        System.out.println("starting benchmark...");
        this.fs.getStatistics().reset();
        CrailBufferedInputStream multiStream = ((CrailNode)this.fs.lookup(filename).get()).asMultiFile().getMultiStream(batch);
        long falseMatches = 0L;
        for (double ops = 0.0; ops < (double)loop; ops += 1.0) {
            System.out.print("reading position " + multiStream.position() + ", expected " + multiStream.position() / 4L + " ");
            long expected = multiStream.position() / 4L;
            int intValue = multiStream.readInt();
            if (expected != (long)intValue) {
                ++falseMatches;
            }
            System.out.println(", value " + intValue);
        }
        multiStream.close();
        System.out.println("falseMatches " + falseMatches);
        this.fs.getStatistics().print("close");
    }

    void printLocationClass() throws Exception {
        System.out.println("locationClass " + this.fs.getLocationClass());
    }

    void locationMap() throws Exception {
        ConcurrentHashMap<String, String> locationMap = new ConcurrentHashMap<String, String>();
        CrailUtils.parseMap(CrailConstants.LOCATION_MAP, locationMap);
        System.out.println("Parsing locationMap " + CrailConstants.LOCATION_MAP);
        for (String key : locationMap.keySet()) {
            System.out.println("key " + key + ", value " + locationMap.get(key));
        }
    }

    void collectionTest(int size, int loop) throws Exception {
        Object tmp;
        int j;
        int i;
        System.out.println("collectionTest, size " + size + ", loop " + loop);
        RingBuffer<Object> ringBuffer = new RingBuffer<Object>(10);
        ArrayBlockingQueue<Object> arrayQueue = new ArrayBlockingQueue<Object>(10);
        LinkedBlockingQueue<Object> listQueue = new LinkedBlockingQueue<Object>();
        Object obj = new Object();
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < loop; ++i2) {
            for (int j2 = 0; j2 < size; ++j2) {
                ringBuffer.add(obj);
                Object tmp2 = ringBuffer.peek();
                tmp2 = ringBuffer.poll();
            }
        }
        long end = System.currentTimeMillis();
        double executionTime = end - start;
        System.out.println("ringbuffer, execution time [ms] " + executionTime);
        start = System.currentTimeMillis();
        for (i = 0; i < loop; ++i) {
            for (j = 0; j < size; ++j) {
                arrayQueue.add(obj);
                tmp = arrayQueue.peek();
                tmp = arrayQueue.poll();
            }
        }
        end = System.currentTimeMillis();
        executionTime = end - start;
        System.out.println("arrayQueue, execution time [ms] " + executionTime);
        start = System.currentTimeMillis();
        for (i = 0; i < loop; ++i) {
            for (j = 0; j < size; ++j) {
                listQueue.add(obj);
                tmp = listQueue.peek();
                tmp = listQueue.poll();
            }
        }
        end = System.currentTimeMillis();
        executionTime = end - start;
        System.out.println("arrayQueue, execution time [ms] " + executionTime);
    }

    private void warmUp(String filename, int operations, ConcurrentLinkedQueue<CrailBuffer> bufferList) throws Exception {
        Random random = new Random();
        String warmupFilename = filename + random.nextInt();
        System.out.println("warmUp, warmupFile " + warmupFilename + ", operations " + operations);
        if (operations > 0) {
            CrailFile warmupFile = ((CrailNode)this.fs.create(warmupFilename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
            CrailBufferedOutputStream warmupStream = warmupFile.getBufferedOutputStream(0L);
            for (int i = 0; i < operations; ++i) {
                CrailBuffer buf = bufferList.poll();
                buf.clear();
                warmupStream.write(buf.getByteBuffer());
                bufferList.add(buf);
            }
            warmupStream.purge().get();
            warmupStream.close();
            ((CrailNode)this.fs.delete(warmupFilename, false).get()).syncDir();
        }
    }

    public static void main(String[] args) throws Exception {
        String type = "";
        String filename = "/tmp.dat";
        int size = CrailConstants.BUFFER_SIZE;
        int loop = 1;
        int batch = 1;
        int warmup = 32;
        int experiments = 1;
        boolean keepOpen = false;
        int storageClass = 0;
        int locationClass = 0;
        boolean useBuffered = true;
        boolean skipDir = false;
        String benchmarkTypes = "write|writeAsync|readSequential|readRandom|readSequentialAsync|readMultiStream|createFile|createFileAsync|createMultiFile|getKey|getFile|getFileAsync|enumerateDir|browseDir|writeInt|readInt|seekInt|readMultiStreamInt|printLocationclass";
        Option typeOption = Option.builder((String)"t").desc("type of experiment [" + benchmarkTypes + "]").hasArg().build();
        Option fileOption = Option.builder((String)"f").desc("filename").hasArg().build();
        Option sizeOption = Option.builder((String)"s").desc("buffer size [bytes]").hasArg().build();
        Option loopOption = Option.builder((String)"k").desc("loop [1..n]").hasArg().build();
        Option batchOption = Option.builder((String)"b").desc("batch size [1..n]").hasArg().build();
        Option storageOption = Option.builder((String)"c").desc("storageClass for file [1..n]").hasArg().build();
        Option locationOption = Option.builder((String)"p").desc("locationClass for file [1..n]").hasArg().build();
        Option warmupOption = Option.builder((String)"w").desc("number of warmup operations [1..n]").hasArg().build();
        Option experimentOption = Option.builder((String)"e").desc("number of experiments [1..n]").hasArg().build();
        Option openOption = Option.builder((String)"o").desc("whether to keep the file system open [true|false]").hasArg().build();
        Option skipDirOption = Option.builder((String)"d").desc("skip writing the directory record [true|false]").hasArg().build();
        Option bufferedOption = Option.builder((String)"m").desc("use buffer streams [true|false]").hasArg().build();
        Options options = new Options();
        options.addOption(typeOption);
        options.addOption(fileOption);
        options.addOption(sizeOption);
        options.addOption(loopOption);
        options.addOption(batchOption);
        options.addOption(storageOption);
        options.addOption(locationOption);
        options.addOption(warmupOption);
        options.addOption(experimentOption);
        options.addOption(openOption);
        options.addOption(bufferedOption);
        options.addOption(skipDirOption);
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, Arrays.copyOfRange(args, 0, args.length));
        if (line.hasOption(typeOption.getOpt())) {
            type = line.getOptionValue(typeOption.getOpt());
        }
        if (line.hasOption(fileOption.getOpt())) {
            filename = line.getOptionValue(fileOption.getOpt());
        }
        if (line.hasOption(sizeOption.getOpt())) {
            size = Integer.parseInt(line.getOptionValue(sizeOption.getOpt()));
        }
        if (line.hasOption(loopOption.getOpt())) {
            loop = Integer.parseInt(line.getOptionValue(loopOption.getOpt()));
        }
        if (line.hasOption(batchOption.getOpt())) {
            batch = Integer.parseInt(line.getOptionValue(batchOption.getOpt()));
        }
        if (line.hasOption(storageOption.getOpt())) {
            storageClass = Integer.parseInt(line.getOptionValue(storageOption.getOpt()));
        }
        if (line.hasOption(locationOption.getOpt())) {
            locationClass = Integer.parseInt(line.getOptionValue(locationOption.getOpt()));
        }
        if (line.hasOption(warmupOption.getOpt())) {
            warmup = Integer.parseInt(line.getOptionValue(warmupOption.getOpt()));
        }
        if (line.hasOption(experimentOption.getOpt())) {
            experiments = Integer.parseInt(line.getOptionValue(experimentOption.getOpt()));
        }
        if (line.hasOption(openOption.getOpt())) {
            keepOpen = Boolean.parseBoolean(line.getOptionValue(openOption.getOpt()));
        }
        if (line.hasOption(bufferedOption.getOpt())) {
            useBuffered = Boolean.parseBoolean(line.getOptionValue(bufferedOption.getOpt()));
        }
        if (line.hasOption(skipDirOption.getOpt())) {
            skipDir = Boolean.parseBoolean(line.getOptionValue(skipDirOption.getOpt()));
        }
        CrailBenchmark benchmark = new CrailBenchmark(warmup);
        if (type.equals("write")) {
            benchmark.open();
            benchmark.write(filename, size, loop, storageClass, locationClass, useBuffered, skipDir);
            benchmark.close();
        } else if (type.equalsIgnoreCase("writeAsync")) {
            benchmark.open();
            benchmark.writeAsync(filename, size, loop, batch, storageClass, locationClass, skipDir);
            benchmark.close();
        } else if (type.equalsIgnoreCase("readSequential")) {
            if (keepOpen) {
                benchmark.open();
            }
            for (int i = 0; i < experiments; ++i) {
                System.out.println("experiment " + i);
                if (!keepOpen) {
                    benchmark.open();
                }
                benchmark.readSequential(filename, size, loop, useBuffered);
                if (keepOpen) continue;
                benchmark.close();
            }
            if (keepOpen) {
                benchmark.close();
            }
        } else if (type.equals("readRandom")) {
            if (keepOpen) {
                benchmark.open();
            }
            for (int i = 0; i < experiments; ++i) {
                System.out.println("experiment " + i);
                if (!keepOpen) {
                    benchmark.open();
                }
                benchmark.readRandom(filename, size, loop, useBuffered);
                if (keepOpen) continue;
                benchmark.close();
            }
            if (keepOpen) {
                benchmark.close();
            }
        } else if (type.equalsIgnoreCase("readSequentialAsync")) {
            if (keepOpen) {
                benchmark.open();
            }
            for (int i = 0; i < experiments; ++i) {
                System.out.println("experiment " + i);
                if (!keepOpen) {
                    benchmark.open();
                }
                benchmark.readSequentialAsync(filename, size, loop, batch);
                if (keepOpen) continue;
                benchmark.close();
            }
            if (keepOpen) {
                benchmark.close();
            }
        } else if (type.equalsIgnoreCase("readMultiStream")) {
            if (keepOpen) {
                benchmark.open();
            }
            for (int i = 0; i < experiments; ++i) {
                System.out.println("experiment " + i);
                if (!keepOpen) {
                    benchmark.open();
                }
                benchmark.readMultiStream(filename, size, loop, batch);
                if (keepOpen) continue;
                benchmark.close();
            }
            if (keepOpen) {
                benchmark.close();
            }
        } else if (type.equals("createFile")) {
            benchmark.open();
            benchmark.createFile(filename, loop);
            benchmark.close();
        } else if (type.equals("createFileAsync")) {
            benchmark.open();
            benchmark.createFileAsync(filename, loop, batch);
            benchmark.close();
        } else if (type.equalsIgnoreCase("createMultiFile")) {
            benchmark.open();
            benchmark.createMultiFile(filename, storageClass);
            benchmark.close();
        } else if (type.equalsIgnoreCase("getKey")) {
            benchmark.open();
            benchmark.getKey(filename, size, loop);
            benchmark.close();
        } else if (type.equals("getFile")) {
            benchmark.open();
            benchmark.getFile(filename, loop);
            benchmark.close();
        } else if (type.equals("getFileAsync")) {
            benchmark.open();
            benchmark.getFileAsync(filename, loop, batch);
            benchmark.close();
        } else if (type.equalsIgnoreCase("enumerateDir")) {
            benchmark.open();
            benchmark.enumerateDir(filename, batch);
            benchmark.close();
        } else if (type.equalsIgnoreCase("browseDir")) {
            benchmark.open();
            benchmark.browseDir(filename);
            benchmark.close();
        } else if (type.equalsIgnoreCase("early")) {
            benchmark.open();
            benchmark.early(filename);
            benchmark.close();
        } else if (type.equalsIgnoreCase("writeInt")) {
            benchmark.open();
            benchmark.writeInt(filename, loop);
            benchmark.close();
        } else if (type.equalsIgnoreCase("readInt")) {
            benchmark.open();
            benchmark.readInt(filename, loop);
            benchmark.close();
        } else if (type.equalsIgnoreCase("seekInt")) {
            benchmark.open();
            benchmark.seekInt(filename, loop);
            benchmark.close();
        } else if (type.equalsIgnoreCase("readMultiStreamInt")) {
            benchmark.open();
            benchmark.readMultiStreamInt(filename, loop, batch);
            benchmark.close();
        } else if (type.equalsIgnoreCase("printLocationClass")) {
            benchmark.open();
            benchmark.printLocationClass();
            benchmark.close();
        } else if (type.equalsIgnoreCase("collection")) {
            for (int i = 0; i < experiments; ++i) {
                benchmark.collectionTest(size, loop);
            }
        } else if (type.equalsIgnoreCase("locationMap")) {
            benchmark.locationMap();
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("crail iobench", options);
            System.exit(-1);
        }
    }
}

