/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage;

import java.io.IOException;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.slf4j.Logger;

public interface StorageClient {
    public StorageEndpoint createEndpoint(DataNodeInfo var1) throws IOException;

    public void close() throws Exception;

    public void init(CrailStatistics var1, CrailBufferCache var2, CrailConfiguration var3, String[] var4) throws IOException;

    public void printConf(Logger var1);

    public static StorageClient createInstance(String name) throws Exception {
        Class<?> nodeClass = Class.forName(name);
        if (StorageClient.class.isAssignableFrom(nodeClass)) {
            Class<?> storageClientClass = nodeClass;
            StorageClient client = (StorageClient)storageClientClass.newInstance();
            return client;
        }
        throw new Exception("Cannot instantiate storage client of type " + name);
    }
}

